;---------  SIDwinder V01.20  ----------
#include op.asm

         *= $0c00

zp1      = $2b             ;1st col
zp2      = $2c
zp3      = $2d             ;2nd col
zp4      = $2e
zp5      = $2f             ;3rd col
zp6      = $30
zp7      = $31             ;sct.len
zp8      = $32
zp9      = $33             ;corner pos

ctinit   = $45fc
volume   = $46bd
dur_dc   = $4653
dur_rs   = $4654
gt_dec   = $464e
trk_lo   = $4664
trk_hi   = $4665
trkpos   = $4666
sctpos   = $4669
f_type   = $46bb
s_nmbr   = $46a7
w_pntr   = $4691
offset   = $46c2

speeds   = $4700
start1   = $4720
start2   = $4740
start3   = $4760

tr1adl   = $4780
tr2adl   = $47a0
tr3adl   = $47c0
tr1adh   = $47e0
tr2adh   = $4800
tr3adh   = $4820

gld_al   = $4840
gld_ah   = $4850

sctadl   = $4880
sctadh   = $48e0

snd_ad   = $4940           ;i_edit!
snd_sr   = $4980
snd_gt   = $49c0
snd_wt   = $4a00
snd_ft   = $4a40
snd_pt   = $4a80
snd_st   = $4ac0

wve_fm   = $4b00
wve_st   = $4c00

flt_rp   = $4d00
flt_fh   = $4e00
flt_rl   = $4f00

pls_rp   = $5000
pls_pl   = $5100
pls_ph   = $5200

sld_rp   = $5300
sld_fl   = $5400
sld_fh   = $5500


         jmp $3a97

call_1   sei
         lda #$01
         sta $d019
calls1   = *+1
         ldy #$00
callr1   = *+1
         lda #$00
         jsr jp1003
         cli
callj1   = *+1
         jmp $ea81
call_2   sei
         lda #$01
         sta $d019
calls2   = *+1
         ldy #$00
callr2   = *+1
         lda #$00
         jsr jp1006
         cli
callj2   = *+1
         jmp $ea81
call_3   sei
         lda #$01
         sta $d019
calls3   = *+1
         ldy #$00
callr3   = *+1
         lda #$00
         jsr jp1006
         cli
callj3   = *+1
         jmp $ea81
call_4   sei
         lda #$01
         sta $d019
calls4   = *+1
         ldy #$00
callr4   = *+1
         lda #$00
         jsr jp1006
         cli
callj4   = *+1
         jmp $ea81
call_5   sei
         lda #$01
         sta $d019
calls5   = *+1
         ldy #$00
callr5   = *+1
         lda #$00
         jsr jp1006
         cli
callj5   = *+1
         jmp $ea81
call_6   sei
         lda #$01
         sta $d019
calls6   = *+1
         ldy #$00
callr6   = *+1
         lda #$00
         jsr jp1006
         cli
callj6   = *+1
         jmp $ea81
call_7   sei
         lda #$01
         sta $d019
calls7   = *+1
         ldy #$00
callr7   = *+1
         lda #$00
         jsr jp1006
         cli
callj7   = *+1
         jmp $ea81
call_8   sei
         lda #$01
         sta $d019
calls8   = *+1
         ldy #$00
callr8   = *+1
         lda #$00
         jsr jp1006
         cli
callj8   = *+1
         jmp $ea81
call_9   sei
         lda #$01
         sta $d019
calls9   = *+1
         ldy #$00
callr9   = *+1
         lda #$00
         jsr jp1006
         cli
callj9   = *+1
         jmp $ea81
call_0   sei
         lda #$01
         sta $d019
calls0   = *+1
         ldy #$00
callr0   = *+1
         lda #$00
         jsr jp1006
         cli
callj0   = *+1
         jmp $ea31

callno   sei               ;stopped
         lda #$01
         sta $d019
         lda #$fa
         sta $d012
         cli
         jmp $ea31

jp1003   sta $d012         ;1st
         sty $0314
         dec $d020
         lda #$f1
         sta irqpnt+1
         lda #$06
         sta irqpnt+2
         lda e_radd
         cmp e_rmax
         bcc notrec
         sta e_rmax
         ldx #$03          ;max.rtime
         jsr irqout
         lda e_radd
notrec   ldx #$00          ;act.rtime
         jsr irqout
         lda $d012
         sta e_ract
         jsr $4003
         lda $d012
         sec
         sbc e_ract
         sta e_radd
         inc $d020
         lda #$00
         ldx #$7a
         cpx e_tr1x        ;trk1 off?
         beq *+5
         sta w_pntr
         cpx e_tr2x        ;trk2 off?
         beq *+5
         sta w_pntr+$07
         cpx e_tr3x        ;trk3 off?
         beq *+5
         sta w_pntr+$0e
         dec e_clkt        ;time
         bne notsec
         lda #$32          ;50 frames
         sta e_clkt
         lda #$19
         sta irqpnt+1
         lda #$07
         sta irqpnt+2
         lda e_secs
         sed
         clc
         adc #$01          ;inc secs
         cmp #$60
         beq yesmin
         sta e_secs
         cld
         jmp yessec
yesmin   lda #$00          ;1 min
         sta e_secs
         lda e_mins
         clc
         adc #$01          ;inc mins
         cmp #$60
         bne notmin
         lda #$00          ;1 hour
notmin   sta e_mins
         cld
         ldx #$00
         jsr irqout
         lda e_secs
yessec   ldx #$03
         jsr irqout
notsec   lda e_acts        ;a.speed
         cmp #$06
         bcc wdatas
         rts
wdatas   lda #$be          ;max 6x
         sta irqpnt+1
         lda #$05
         sta irqpnt+2
         lda trkpos        ;trk
         sec
         sbc #$01
         ldx #$00
         jsr irqout
         lda trkpos+$07
         sec
         sbc #$01
         ldx #$03
         jsr irqout
         lda trkpos+$0e
         sec
         sbc #$01
         ldx #$06
         jsr irqout
         lda dur_rs        ;dur
         clc
         adc #$01
         ldx #$0f
         jsr irqout
         lda dur_rs+$07
         clc
         adc #$01
         ldx #$12
         jsr irqout
         lda dur_rs+$0e
         clc
         adc #$01
         ldx #$15
         jsr irqout
         lda sctpos        ;sct
         ldx #$28
         jsr irqout
         lda sctpos+$07
         ldx #$2b
         jsr irqout
         lda sctpos+$0e
         ldx #$2e
         jsr irqout
         lda dur_dc        ;act
         ldx #$37
         jsr irqout
         lda dur_dc+$07
         ldx #$3a
         jsr irqout
         lda dur_dc+$0e
         ldx #$3d
         jsr irqout
         lda s_nmbr        ;snd
         ldx #$50
         jsr irqout
         lda s_nmbr+$07
         ldx #$53
         jsr irqout
         lda s_nmbr+$0e
         ldx #$56
         jsr irqout
         lda gt_dec        ;off
         ldx #$5f
         jsr irqout
         lda gt_dec+$07
         ldx #$62
         jsr irqout
         lda gt_dec+$0e
         ldx #$65
         jmp irqout

jp1006   sta $d012         ;multi
         sty $0314
         dec $d020
         lda $d012
         sta e_ract
         jsr $4006
         lda $d012
         sec
         sbc e_ract
         clc
         adc e_radd
         sta e_radd
         inc $d020
         rts

setspd   ldy e_tune
         lda speeds,y
         sta e_acts
         tay
         lda call1s,y
         sta calls1
         lda call1r,y
         sta callr1
         lda call1j,y
         sta callj1
         lda call2s,y
         sta calls2
         lda call2r,y
         sta callr2
         lda call2j,y
         sta callj2
         lda call3s,y
         sta calls3
         lda call3r,y
         sta callr3
         lda call3j,y
         sta callj3
         lda call4s,y
         sta calls4
         lda call4r,y
         sta callr4
         lda call4j,y
         sta callj4
         lda call5s,y
         sta calls5
         lda call5r,y
         sta callr5
         lda call5j,y
         sta callj5
         lda call6s,y
         sta calls6
         lda call6r,y
         sta callr6
         lda call6j,y
         sta callj6
         lda call7s,y
         sta calls7
         lda call7r,y
         sta callr7
         lda call7j,y
         sta callj7
         lda call8s,y
         sta calls8
         lda call8r,y
         sta callr8
         lda call8j,y
         sta callj8
         lda call9s,y
         sta calls9
         lda call9r,y
         sta callr9
         lda call9j,y
         sta callj9
         lda call0s,y
         sta calls0
         lda call0r,y
         sta callr0
         lda call0j,y
         sta callj0
         lda rstart,y
         rts

getkey   lda #$00
         sta $c6
         lda $c6
         beq *-2
         lda $0277
         cmp #$0d          ;return
         beq accept
         cmp #$11          ;c.down
         beq accept
         cmp #$13          ;home
         beq accept
         cmp #$14          ;delete
         beq accept
         cmp #$1d          ;c.right
         beq accept
         cmp #$91          ;c.up
         beq accept
         cmp #$94          ;insert
         beq accept
         cmp #$9d          ;c.left
         beq accept
         cmp #$c4          ;sh.d
         beq accept
         cmp #$c5          ;sh.e
         beq accept
         cmp #$c7          ;sh.g
         beq accept
         cmp #$c8          ;sh.h
         beq accept
         cmp #$c9          ;sh.i
         beq accept
         cmp #$ca          ;sh.j
         beq accept
         cmp #$d3          ;sh.s
         beq accept
         cmp #$d6          ;sh.v
         beq accept
         cmp #$db          ;sh.+
         beq accept
         cmp #$dd          ;sh.-
         beq accept
         cmp #$20
         bcc getkey
         cmp #$8e
         bcs getkey
         cmp #$60
         bcc accept
         cmp #$85
         bcc getkey
accept   rts

irqout   ldy $0429
         cpy #$54
         bne irqpnt+3
         pha               ;hex #
         lsr a
         lsr a
         lsr a
         lsr a
         dex
         jsr irqcnv
         pla
         and #$0f
irqcnv   ora #$30
         inx
         cmp #$3a
         bcc irqpnt
         clc
         adc #$07
irqpnt   sta $face,x
         rts

numout   pha               ;hex #
         lsr a
         lsr a
         lsr a
         lsr a
         dex
         jsr numcnv
         pla
         and #$0f
numcnv   ora #$30
         inx
         cmp #$3a
         bcc numpnt
         clc
         adc #$07
numpnt   sta $face,x
         rts

fncout   sta fncnum+1      ;function
         lda $0429
         cmp #$54
         beq fncend
         tya
         pha
fncnum   ldy #$00
         lda fncadl,y
         sta fncpnt+1
         lda fncadh,y
         sta fncpnt+2
         ldy #$11
fncpnt   lda $face,y
         sta $043c,y
         dey
         bpl fncpnt
         pla
         tay
fncend   rts

colsnd   tya               ;snd.
         pha
         ldy #$27
         lda #$0f
collp1   sta $d878,y
         dey
         bpl collp1
         pla
         tay
         rts

colafp   tya               ;arp+flt+pls
         pha
         ldy #$ff
         lda #$0f
collp2   sta $d940,y
         dey
         bne collp2
         pla
         tay
         rts

coltrs   tya               ;trk+sct
         pha
         ldy #$ff
         lda #$0f
collp3   sta $d878,y
         dey
         bne collp3
         pla
         tay
         rts

colsta   tya               ;trst.
         pha
         ldy #$07
         lda #$0f
collp4   sta $da9e,y
         dey
         bpl collp4
         ldy #$04
collp5   sta $db69,y
         dey
         bpl collp5
         pla
         tay
         rts

colgld   tya               ;gld+more
         pha
         ldy #$ff
         lda #$0f
collp6   sta $dad0,y
         dey
         bne collp6
         pla
         tay
         rts

sndtab   txa               ;tables
         pha
         tya
         pha
         lda zp9
         pha
         lda #$2f
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_sndn
         ldx #$00
         tya               ;#
         jsr numout
         lda #$82
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldx #$00
         lda snd_ad,y      ;ad
         jsr numout
         ldx #$03
         lda snd_sr,y      ;sr
         jsr numout
         ldx #$06
         lda snd_gt,y      ;gt
         jsr numout
         ldx #$09
         lda snd_wt,y      ;wt
         jsr numout
         ldx #$0c
         lda snd_ft,y      ;ft
         jsr numout
         ldx #$0f
         lda snd_pt,y      ;pt
         jsr numout
         ldx #$12
         lda snd_st,y      ;st
         jsr numout
         lda e_test        ;note
         ldy #$08
notest   dey
         cmp octave,y
         bcc notest
         sbc octave,y      ;c=1
         asl a
         tax
         lda twelve,x
         sta $047e
         lda twelve+1,x
         sta $047f
         iny
         tya
         ora #$30
         sta $0480
         pla
         sta zp9
         pla
         tay
         pla
         tax
         rts

chk_fa   lda zp9
         cmp #$fb
         bcc *+6
         lda #$fa
         sta zp9
         rts

wvetab   jsr chk_fa
         lda #LO(wve_fm)
         clc
         adc zp9
         sta zp1
         lda #HI(wve_fm)
         sta zp2
         lda #LO(wve_st)
         clc
         adc zp9
         sta zp3
         lda #HI(wve_st)
         sta zp4
         lda #$00
         sta zp5
         sta zp6
         lda #$42
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

flttab   jsr chk_fa
         lda #LO(flt_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(flt_rp)
         sta zp2
         lda #LO(flt_fh)
         clc
         adc zp9
         sta zp3
         lda #HI(flt_fh)
         sta zp4
         lda #LO(flt_rl)
         clc
         adc zp9
         sta zp5
         lda #HI(flt_rl)
         sta zp6
         lda #$4d
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

plstab   jsr chk_fa
         lda #LO(pls_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(pls_rp)
         sta zp2
         lda #LO(pls_ph)
         clc
         adc zp9
         sta zp3
         lda #HI(pls_ph)
         sta zp4
         lda #LO(pls_pl)
         clc
         adc zp9
         sta zp5
         lda #HI(pls_pl)
         sta zp6
         lda #$5b
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

gldtab   lda #LO(gld_ah)
         clc
         adc zp9
         sta zp1
         lda #HI(gld_ah)
         adc #$00
         sta zp2
         lda #LO(gld_al)
         clc
         adc zp9
         sta zp3
         lda #HI(gld_al)
         adc #$00
         sta zp4
         lda #$00
         sta zp5
         sta zp6
         lda #$d2
         sta numpnt+1
         lda #$06
         sta numpnt+2
         jmp tblout

sldtab   jsr chk_fa
         lda #LO(sld_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(sld_rp)
         sta zp2
         lda #LO(sld_fh)
         clc
         adc zp9
         sta zp3
         lda #HI(sld_fh)
         sta zp4
         lda #LO(sld_fl)
         clc
         adc zp9
         sta zp5
         lda #HI(sld_fl)
         sta zp6
         lda #$dd
         sta numpnt+1
         lda #$06
         sta numpnt+2
         jmp tblout

trstab   lda #LO(start1)
         clc
         adc zp9
         sta zp1
         lda #HI(start1)
         adc #$00
         sta zp2
         lda #LO(start2)
         clc
         adc zp9
         sta zp3
         lda #HI(start2)
         adc #$00
         sta zp4
         lda #LO(start3)
         clc
         adc zp9
         sta zp5
         lda #HI(start3)
         adc #$00
         sta zp6
         lda #$eb
         sta numpnt+1
         lda #$06
         sta numpnt+2

tblout   txa               ;write
         pha
         tya
         pha
         ldy #$05
loop01   ldx x_line,y
         tya
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp1),y
         jsr numout
         inx
         inx
         lda (zp3),y
         jsr numout
         lda zp6
         beq twocol
         inx
         inx
         lda (zp5),y
         jsr numout
twocol   dey
         bpl loop01
         pla
         tay
         pla
         tax
         rts

sctout   txa               ;sector
         pha
         tya
         pha
         lda #$4c
         sta numpnt+1
         lda #$04
         sta numpnt+2
         lda e_sctn
         ldx #$00
         jsr numout
         ldx e_sctn
         lda sctadl,x
         clc
         adc zp9
         sta zp1
         lda sctadh,x
         adc #$00
         sta zp2
         lda #$95
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy #$05          ;sct.out
loop02   ldx x_line,y
         tya
         pha
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp1),y
         cmp #$c0
         bcc nossnd
         and #$3f
         pha
         lda #LO(sc_snd)
         ldy #HI(sc_snd)
seclin   sta sndwrt+1
         sty sndwrt+2
         ldy #$00
sndwrt   lda $face,y
         sta $0495,x       ;sector
         inx
         iny
         cpy #$04
         bne sndwrt
         pla
         jsr numout
loop03   pla
         tay
         dey
         bpl loop02
         pla
         tay
         pla
         tax
         rts
nossnd   cmp #$80
         bcc nosdur
         sbc #$7f
         pha
         lda #LO(sc_dur)
         ldy #HI(sc_dur)
         jmp seclin
nosdur   cmp #$7f
         bne nosend
         lda #LO(sc_end)
         ldy #HI(sc_end)
fullin   sta fullwt+1
         sty fullwt+2
         ldy #$00
fullwt   lda $face,y
         sta $0495,x
         inx
         iny
         cpy #$06
         bne fullwt
         jmp loop03
nosend   cmp #$6f
         bne nohold
         lda #LO(sc_hld)
         ldy #HI(sc_hld)
         jmp fullin
nohold   cmp #$5f
         bne norest
         lda #LO(sc_rst)
         ldy #HI(sc_rst)
         jmp fullin
norest   cmp #$60
         bcc nosgld
         and #$1f
         clc
         adc #$01
         pha
         lda #LO(sc_gld)
         ldy #HI(sc_gld)
         jmp seclin
nosgld   ldy #$08
         dey
         cmp octave,y
         bcc nosgld+2
         sbc octave,y      ;c=1
         asl a
         pha
         iny
         tya
         ora #$30
         sta $0498,x
         lda #$20
         sta $0495,x
         sta $0499,x
         sta $049a,x
         pla
         tay
         lda twelve,y
         sta $0496,x
         lda twelve+1,y
         sta $0497,x
         jmp loop03

sctlen   txa               ;length
         pha
         tya
         pha
         ldy e_sctn
         lda sctadl,y
         sta zp7
         lda sctadh,y
         sta zp8
         lda #$29
         sta numpnt+1
         lda #$06
         sta numpnt+2
         ldy #$00
         sty len_lo
         sty len_hi
         sty actdur
         beq sctcmd
skip_2   iny
         beq sctend
skip_1   iny
         beq sctend
sctcmd   lda (zp7),y
         cmp #$60
         bcs nonote
adddur   lda len_lo
         clc
         adc actdur
         sta len_lo
         bcc skip_1
         inc len_hi
         jmp skip_1
nonote   cmp #$6f
         beq adddur
         bcc skip_2
         cmp #$7f
         beq sctend
         cmp #$c0
         bcs skip_1
         sec
         sbc #$7f
         sta actdur
         jmp skip_1
sctend   ldx #$02
         lda len_lo
         jsr numout
         ldx #$00
         lda len_hi
         jsr numout
         pla
         tay
         pla
         tax
         rts

tr1out   txa               ;tracks
         pha
         tya
         pha
         jsr chk_fa
         lda #$79
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr1adl,y
         clc
         adc zp9
         sta zp7
         lda tr1adh,y
         adc #$00
         sta zp8
         jmp trkout

tr2out   txa
         pha
         tya
         pha
         jsr chk_fa
         lda #$82
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr2adl,y
         clc
         adc zp9
         sta zp7
         lda tr2adh,y
         adc #$00
         sta zp8
         jmp trkout

tr3out   txa
         pha
         tya
         pha
         jsr chk_fa
         lda #$8b
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr3adl,y
         clc
         adc zp9
         sta zp7
         lda tr3adh,y
         adc #$00
         sta zp8

trkout   ldy #$00
         ldx x_line,y
         tya
         pha
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp7),y
         cmp #$40
         bcs nottup
         pha
         lda #LO(tr_tup)
         ldy #HI(tr_tup)
trklin   sta trkwrt+1
         sty trkwrt+2
         ldy #$00
trkwrt   lda $face,y
         sta $0400,x
         inx
         iny
         cpy #$05
         bne trkwrt
         pla
         cmp #$ff
         beq nonumb
         dex
         dex
         jsr numout
nonumb   pla
         tay
         iny
         cpy #$06
         bne trkout+2
         dec zp7           ;top space
         ldy #$00
         lda (zp7),y
         inc zp7
         cmp #$ff
         bne nextra
         lda trkwrt+4
         sta cextra+1
         ldx #$07
         lda #$20
cextra   sta $0400,x
         dex
         bpl cextra
nextra   pla
         tay
         pla
         tax
         rts
nottup   cmp #$80
         bcs nottdn
         and #$3f
         pha
         lda #LO(tr_tdn)
         ldy #HI(tr_tdn)
         jmp trklin
nottdn   cmp #$e0
         bcs notsct
         and #$7f
         pha
         lda #LO(tr_sct)
         ldy #HI(tr_sct)
         jmp trklin
notsct   cmp #$f0
         beq haltvp
         bcs notvol
         and #$0f
         pha
         lda #LO(tr_vol)
         ldy #HI(tr_vol)
         jmp trklin
haltvp   lda #$ff
         pha
         lda #LO(tr_hlt)
         ldy #HI(tr_hlt)
         jmp trklin
notvol   cmp #$f8
         bcs notdec
         and #$0f
         pha
         lda #LO(tr_dec)
         ldy #HI(tr_dec)
         jmp trklin
notdec   cmp #$ff
         bcs notinc
         sec
         sbc #$f7
         pha
         lda #LO(tr_inc)
         ldy #HI(tr_inc)
         jmp trklin
notinc   cpy #$05
         beq skpclr
         txa
         pha
         clc
         adc trkwrt+4
         sta afterj+1
         lda trkwrt+5
         adc #$00
         sta afterj+2
         ldx #$25
         lda #$20
afterj   sta $face,x
         inx
         cpx #$2d
         bne afterj
         pla
         tax
         pla               ;y=y+1
         clc
         adc #$01
         pha
skpclr   iny
         lda (zp7),y
         pha
         lda #LO(tr_jmp)
         ldy #HI(tr_jmp)
         jmp trklin

f1_key   sei               ;play
         txa
         pha
         tya
         pha
         lda #$00
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda #$80
         sta ttrack+1
         lda e_tune
         jsr $4000
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

f2_key   sei               ;sector
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda e_sctn
         ora #$80
         sta ttrack+1
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

f3_key   sei               ;stop
         lda #LO(callno)
         sta $0314
         lda #HI(callno)
         sta $0315
         lda #$80
         sta ttrack+1
         lda #$fa
         sta $d012
         lda #$00
         sta $d418
         cli
         rts

f4_key   sei               ;sfx
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda #$df          ;sct.#
         sta ttrack+1
         lda e_sndn        ;snd.#
         ora #$c0
         sta $cf00
         lda e_test        ;note
         sta $cf02
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

spaces   lda $0314         ;sfx on?
         cmp #LO(callno)
         beq spcend
         lda ttrack+1
         cmp #$df
         bne spcend
         sei
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         lda e_sndn        ;snd.#
         ora #$c0
         sta $cf00
         lda e_test        ;note
         sta $cf02
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
spcend   lda #$00
         cli
         rts

f5_key   lda $0314
         cmp #LO(callno)
         bne f5_end
         sei
         tya
         pha
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda f_type
         ora volume
         sta $d418
         pla
         tay
f5_end   lda #$00
         cli
         rts

f7_key   lda $0314
         cmp #LO(callno)
         beq f5_end
         sei
         txa
         pha
         tya
         pha
f7_fwd   ldx #$00
         dex
         bne *-1
         dex
         bne *-1
         jsr fast_f
         lda #$fe
         sta $dc00
         lda $dc01
         and #$08
         beq f7_fwd
         bit $d011
         bpl *-3
         bit $d011
         bmi *-3
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

fast_f   dec e_clkt        ;time
         bne fast_e
         lda #$32          ;50 frames
         sta e_clkt
         lda #$19
         sta irqpnt+1
         lda #$07
         sta irqpnt+2
         lda e_secs
         sed
         clc
         adc #$01          ;inc secs
         cmp #$60
         beq fast_m
         sta e_secs
         cld
         jmp fast_s
fast_m   lda #$00          ;1 min
         sta e_secs
         lda e_mins
         clc
         adc #$01          ;inc mins
         cmp #$60
         bne fast_n
         lda #$00          ;1 hour
fast_n   sta e_mins
         cld
         ldx #$00
         jsr irqout
         lda e_secs
fast_s   ldx #$03
         jsr irqout
fast_e   jmp $4003

f6_key   dec e_tune
         jmp *+6
f8_key   inc e_tune
         txa
         pha
         lda zp9
         pha
         lda e_tune
         and #$1f
         sta e_tune
         tax
         jsr startw
         lda start1,x
         sta e_tr1p
         sta zp9
         jsr tr1out
         lda start2,x
         sta e_tr2p
         sta zp9
         jsr tr2out
         lda start3,x
         sta e_tr3p
         sta zp9
         jsr tr3out
         pla
         sta zp9
         pla
         tax
         lda #$01
         rts

onoff1   lda e_tr1x        ;trk1 on
         eor #$62          ;toggle
         sta e_tr1x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr1x
         sta $0430
         lda #$00
         rts
onoff2   lda e_tr2x
         eor #$62
         sta e_tr2x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr2x
         sta $0439
         lda #$00
         rts
onoff3   lda e_tr3x
         eor #$62
         sta e_tr3x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr3x
         sta $0442
         lda #$00
         rts

sounds   jsr sndtab        ;screen
         ldy e_sndn
         lda snd_wt,y
         sta zp9
         jsr wvetab
         lda snd_ft,y
         sta zp9
         jsr flttab
         lda snd_pt,y
         sta zp9
         jsr plstab
         lda e_gldp
         sta zp9
         jsr gldtab
         lda snd_st,y
         sta zp9
         jsr sldtab
         lda e_tune
         sta zp9
         jmp trstab

startw   txa               ;corner
         pha
         lda #$9e
         sta numpnt+1
         lda #$06
         sta numpnt+2
         ldx e_tune
         lda start1,x      ;trst
         ldx #$00
         jsr numout
         ldx e_tune
         lda start2,x
         ldx #$03
         jsr numout
         ldx e_tune
         lda start3,x
         ldx #$06
         jsr numout
         lda e_rmax
         ldx #$56
         jsr numout
         lda e_mins        ;time
         ldx #$7b
         jsr numout
         lda e_secs
         ldx #$7e
         jsr numout
         lda e_tune        ;tune#
         ldx #$cb
         jsr numout
         ldx e_tune
         lda speeds,x
         ldx #$ce
         jsr numout
         pla
         tax
         rts

keychk   cmp #$2c          ;trk.sw.
         bne *+5
         jmp onoff1
         cmp #$2e
         bne *+5
         jmp onoff2
         cmp #$2f
         bne *+5
         jmp onoff3
         cmp #$85          ;f-keys
         bne *+5
         jmp f1_key
         cmp #$86
         bne *+5
         jmp f3_key
         cmp #$87
         bne *+5
         jmp f5_key
         cmp #$88
         bne *+5
         jmp f7_key
         cmp #$89
         bne *+5
         jmp f2_key
         cmp #$8a
         bne *+5
         jmp f4_key
         cmp #$8b
         bne *+12
         lda $0429
         cmp #$53
         beq keyfnd
         jmp f6_key
         cmp #$8c
         bne *+14
         lda $0429
         cmp #$53
         beq keyfnd
         jmp f8_key
keyfnd   lda #$00
         rts

         *= $1898
w_edit   = *
         *= $1afa
f_edit   = *
         *= $1d6c
p_edit   = *
         *= $1fde
g_edit   = *
         *= $2193
v_edit   = *
         *= $2405
r_edit   = *
         *= $2609
i_edit   = *
         *= $279a

jmpnum   iny
         lda (zp7),y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sta (zp7),y
         dey
         rts
incnum   lda e_orad
         beq incend
         cmp #$08
         bcs incend
         adc #$f7
         sta (zp7),y
incend   rts
decnum   lda e_orad
         beq incend
         cmp #$08
         bcs incend
         adc #$f0
         sta (zp7),y
         rts
volnum   lda e_orad
         clc
         adc #$e0
         sta (zp7),y
         rts
sctnum   asl a
         asl a
         asl a
         asl a
         and #$7f
         cmp #$60
         bcc *+4
         and #$3f
         ora #$80
         ora e_orad
         sta (zp7),y
         rts
trdnum   asl a
         asl a
         asl a
         asl a
         and #$30
         ora #$40
         ora e_orad
         sta (zp7),y
         rts
trunum   asl a
         asl a
         asl a
         asl a
         and #$30
         ora e_orad
         sta (zp7),y
         rts

t1edit   lda e_tr1p        ;track1
         sta zp9
         ldy #$00
t1loop   jsr coltrs
         ldx x_line,y
         lda #$01
         sta $d87c,x
         sta $d87d,x
         sta $d87e,x
         sta $d87f,x
         sta $d880,x
         jsr tr1out
t1newc   jsr getkey
         cmp #$20
         beq t1newc
         cmp #$0d
         beq t1down
         cmp #$11
         bne t1home
t1down   cpy #$05
         bne t1dint
         lda zp9           ;scroll
         cmp #$fa
         bcs t1newc
         inc zp9
         jmp t1loop
t1dint   iny               ;down
         jmp t1loop
t1home   cmp #$13
         bne t1delc
         ldy e_tune
         lda start1,y
         sta zp9
         jmp t1edit+5
t1delc   cmp #$14          ;delete
         bne t1rght
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq t1dele
         ldx #$1f          ;mod.pntr
t1dcmp   cmp start1,x
         bcs t1dlow
         dec start1,x
t1dlow   dex
         bpl t1dcmp
         sta e_orad
         tya
         tax
         ldy #$00
t1djst   lda (zp7),y
         cmp #$ff          ;jmp?
         bne t1djnx
         iny
         lda e_orad
         cmp (zp7),y
         bcs t1djnx-4
         lda (zp7),y
         sec
         sbc #$01
         sta (zp7),y
         cpy #$ff
         beq *+7
t1djnx   iny
         cpy #$ff
         bne t1djst
         txa
         tay
         jsr startw
         lda #$ff
         sec
         sbc zp9
         sta t1dcpy+1
t1delp   iny
         lda (zp7),y
         dey
         sta (zp7),y
         iny
t1dcpy   cpy #$00
         bne t1delp
t1dele   lda #$80
         sta (zp7),y
         pla
         tay
         pla
         tax
         jmp t1loop
t1rght   cmp #$1d
         bne t1uppp
         lda zp9
         sta e_tr1p
         lda e_tr2p
         sta zp9
         jmp t2loop
t1uppp   cmp #$91
         bne t1inst
         cpy #$00
         bne t1uint
         lda zp9           ;scroll
         bne *+5
         jmp t1newc
         dec zp9
         jmp t1loop
t1uint   dey               ;down
         jmp t1loop
t1inst   cmp #$94
         bne t1gsnd
         txa
         pha
         sty t1icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq t1inse
         ldx #$1f
t1icmp   cmp start1,x      ;mod.pntr
         beq t1ilow-3
         bcs t1ilow
         inc start1,x
t1ilow   dex
         bpl t1icmp
         sta e_orad
         ldy #$00
t1ijst   lda (zp7),y
         cmp #$ff          ;jmp?
         bne t1ijnx
         iny
         lda e_orad
         cmp (zp7),y
         beq *+4
         bcs t1ijnx-4
         lda (zp7),y
         clc
         adc #$01
         sta (zp7),y
         cpy #$ff
         beq *+7
t1ijnx   iny
         cpy #$ff
         bne t1ijst
         jsr startw
         lda #$ff
         sec
         sbc zp9
         tay
t1islp   dey
         lda (zp7),y
         iny
         sta (zp7),y
         dey
t1icpy   cpy #$00
         bne t1islp
t1inse   lda #$80
         sta (zp7),y
         pla
         tax
         jmp t1loop
t1gsnd   cmp #$28          ;exit
         bcs t1font
         and #$07
         tay
         lda zp9
         sta e_tr1p
         jmp coltrs
t1font   cmp #$5c
         bne t1scrn
         tya
         clc
         adc zp9
         ldx e_tune
         sta start1,x
         sta zp9
         jsr chk_fa
         sta e_tr1p
         jsr startw
         jmp t1edit
t1scrn   cmp #$5f          ;to editor
         bne t1tr1x
         ldy #$00
         lda zp9
         sta e_tr1p
         jmp coltrs
t1tr1x   jsr keychk
         beq *+9
         cmp #$01
         bne t1sret
         jmp t1edit
         jmp t1newc
t1sret   cmp #$8d
         bne t1lett
         lda #$01
         sta e_ltrk
         lda (zp7),y
         cmp #$80
         bcc t1sre1
         cmp #$e0
         bcs t1sre1
         and #$7f
         sta e_sctn
t1sre1   ldy #$04
         lda zp9
         sta e_tr1p
         jmp coltrs
t1lett   cmp #$c4          ;sh.d
         bne *+6
         lda #$f1
         bne t1lcmd
         cmp #$c8          ;sh.h
         bne *+6
         lda #$f0
         bne t1lcmd
         cmp #$c9          ;sh.i
         bne *+6
         lda #$f8
         bne t1lcmd
         cmp #$ca          ;sh.j
         bne *+6
         lda #$ff
         bne t1lcmd
         cmp #$d3          ;sh.s
         bne *+6
         lda #$80
         bne t1lcmd
         cmp #$d6          ;sh.v
         bne *+6
         lda #$e0
         bne t1lcmd
         cmp #$2b          ;+
         beq *+6
         cmp #$db          ;sh.+
         bne *+6
         lda #$00
         beq t1lcmd
         cmp #$2d          ;-
         beq *+6
         cmp #$dd          ;sh.-
         bne t1numb
         lda #$40
t1lcmd   sta (zp7),y
         jmp t1newc-3
t1numb   cmp #$30          ;number
         bcc t1back
         cmp #$3a
         bcc t1back+3
         cmp #$41
         bcc t1back
         cmp #$47
         bcc t1back+3
t1back   jmp t1newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
         lda (zp7),y
         cmp #$ff          ;jmp
         bne *+8
         jsr jmpnum
         jmp t1newc-3
         cmp #$f8          ;inc
         bcc *+8
         jsr incnum
         jmp t1newc-3
         cmp #$f0          ;hlt
         beq t1back
         bcc *+8
         jsr decnum        ;dec
         jmp t1newc-3
         cmp #$e0          ;vol
         bcc *+8
         jsr volnum
         jmp t1newc-3
         cmp #$80          ;sct
         bcc *+8
         jsr sctnum
         jmp t1newc-3
         cmp #$40          ;tr-
         bcc *+8
         jsr trdnum
         jmp t1newc-3
         jsr trunum        ;tr+
         jmp t1newc-3

t2edit   lda e_tr2p        ;track2
         sta zp9
         ldy #$00
t2loop   jsr coltrs
         ldx x_line,y
         lda #$01
         sta $d885,x
         sta $d886,x
         sta $d887,x
         sta $d888,x
         sta $d889,x
         jsr tr2out
t2newc   jsr getkey
         cmp #$20
         beq t2newc
         cmp #$0d
         beq t2down
         cmp #$11
         bne t2home
t2down   cpy #$05
         bne t2dint
         lda zp9           ;scroll
         cmp #$fa
         bcs t2newc
         inc zp9
         jmp t2loop
t2dint   iny               ;down
         jmp t2loop
t2home   cmp #$13
         bne t2delc
         ldy e_tune
         lda start2,y
         sta zp9
         jmp t2edit+5
t2delc   cmp #$14          ;delete
         bne t2rght
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq t2dele
         ldx #$1f          ;mod.pntr
t2dcmp   cmp start2,x
         bcs t2dlow
         dec start2,x
t2dlow   dex
         bpl t2dcmp
         sta e_orad
         tya
         tax
         ldy #$00
t2djst   lda (zp7),y
         cmp #$ff          ;jmp?
         bne t2djnx
         iny
         lda e_orad
         cmp (zp7),y
         bcs t2djnx-4
         lda (zp7),y
         sec
         sbc #$01
         sta (zp7),y
         cpy #$ff
         beq *+7
t2djnx   iny
         cpy #$ff
         bne t2djst
         txa
         tay
         jsr startw
         lda #$ff
         sec
         sbc zp9
         sta t2dcpy+1
t2delp   iny
         lda (zp7),y
         dey
         sta (zp7),y
         iny
t2dcpy   cpy #$00
         bne t2delp
t2dele   lda #$80
         sta (zp7),y
         pla
         tay
         pla
         tax
         jmp t2loop
t2rght   cmp #$1d
         bne t2uppp
         lda zp9
         sta e_tr2p
         lda e_tr3p
         sta zp9
         jmp t3loop
t2uppp   cmp #$91
         bne t2inst
         cpy #$00
         bne t2uint
         lda zp9           ;scroll
         bne *+5
         jmp t2newc
         dec zp9
         jmp t2loop
t2uint   dey               ;down
         jmp t2loop
t2inst   cmp #$94
         bne t2left
         txa
         pha
         sty t2icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq t2inse
         ldx #$1f
t2icmp   cmp start2,x      ;mod.pntr
         beq t2ilow-3
         bcs t2ilow
         inc start2,x
t2ilow   dex
         bpl t2icmp
         sta e_orad
         ldy #$00
t2ijst   lda (zp7),y
         cmp #$ff          ;jmp?
         bne t2ijnx
         iny
         lda e_orad
         cmp (zp7),y
         beq *+4
         bcs t2ijnx-4
         lda (zp7),y
         clc
         adc #$01
         sta (zp7),y
         cpy #$ff
         beq *+7
t2ijnx   iny
         cpy #$ff
         bne t2ijst
         jsr startw
         lda #$ff
         sec
         sbc zp9
         tay
t2islp   dey
         lda (zp7),y
         iny
         sta (zp7),y
         dey
t2icpy   cpy #$00
         bne t2islp
t2inse   lda #$80
         sta (zp7),y
         pla
         tax
         jmp t2loop
t2left   cmp #$9d
         bne t2gsnd
         lda zp9
         sta e_tr2p
         lda e_tr1p
         sta zp9
         jmp t1loop
t2gsnd   cmp #$28          ;exit
         bcs t2font
         and #$07
         tay
         lda zp9
         sta e_tr2p
         jmp coltrs
t2font   cmp #$5c
         bne t2scrn
         tya
         clc
         adc zp9
         ldx e_tune
         sta start2,x
         sta zp9
         jsr chk_fa
         sta e_tr2p
         jsr startw
         jmp t2edit
t2scrn   cmp #$5f          ;to editor
         bne t2tr1x
         ldy #$00
         lda zp9
         sta e_tr2p
         jmp coltrs
t2tr1x   jsr keychk
         beq *+9
         cmp #$01
         bne t2sret
         jmp t2edit
         jmp t2newc
t2sret   cmp #$8d
         bne t2lett
         lda #$02
         sta e_ltrk
         lda (zp7),y
         cmp #$80
         bcc t2sre1
         cmp #$e0
         bcs t2sre1
         and #$7f
         sta e_sctn
t2sre1   ldy #$04
         lda zp9
         sta e_tr2p
         jmp coltrs
t2lett   cmp #$c4          ;sh.d
         bne *+6
         lda #$f1
         bne t2lcmd
         cmp #$c8          ;sh.h
         bne *+6
         lda #$f0
         bne t2lcmd
         cmp #$c9          ;sh.i
         bne *+6
         lda #$f8
         bne t2lcmd
         cmp #$ca          ;sh.j
         bne *+6
         lda #$ff
         bne t2lcmd
         cmp #$d3          ;sh.s
         bne *+6
         lda #$80
         bne t2lcmd
         cmp #$d6          ;sh.v
         bne *+6
         lda #$e0
         bne t2lcmd
         cmp #$2b          ;+
         beq *+6
         cmp #$db          ;sh.+
         bne *+6
         lda #$00
         beq t2lcmd
         cmp #$2d          ;-
         beq *+6
         cmp #$dd          ;sh.-
         bne t2numb
         lda #$40
t2lcmd   sta (zp7),y
         jmp t2newc-3
t2numb   cmp #$30          ;number
         bcc t2back
         cmp #$3a
         bcc t2back+3
         cmp #$41
         bcc t2back
         cmp #$47
         bcc t2back+3
t2back   jmp t2newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
         lda (zp7),y
         cmp #$ff          ;jmp
         bne *+8
         jsr jmpnum
         jmp t2newc-3
         cmp #$f8          ;inc
         bcc *+8
         jsr incnum
         jmp t2newc-3
         cmp #$f0          ;hlt
         beq t2back
         bcc *+8
         jsr decnum        ;dec
         jmp t2newc-3
         cmp #$e0          ;vol
         bcc *+8
         jsr volnum
         jmp t2newc-3
         cmp #$80          ;sct
         bcc *+8
         jsr sctnum
         jmp t2newc-3
         cmp #$40          ;tr-
         bcc *+8
         jsr trdnum
         jmp t2newc-3
         jsr trunum        ;tr+
         jmp t2newc-3

t3edit   lda e_tr3p        ;track3
         sta zp9
         ldy #$00
t3loop   jsr coltrs
         ldx x_line,y
         lda #$01
         sta $d88e,x
         sta $d88f,x
         sta $d890,x
         sta $d891,x
         sta $d892,x
         jsr tr3out
t3newc   jsr getkey
         cmp #$1d
         beq t3newc
         cmp #$20
         beq t3newc
         cmp #$0d
         beq t3down
         cmp #$11
         bne t3home
t3down   cpy #$05
         bne t3dint
         lda zp9           ;scroll
         cmp #$fa
         bcs t3newc
         inc zp9
         jmp t3loop
t3dint   iny               ;down
         jmp t3loop
t3home   cmp #$13
         bne t3delc
         ldy e_tune
         lda start3,y
         sta zp9
         jmp t3edit+5
t3delc   cmp #$14          ;delete
         bne t3uppp
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq t3dele
         ldx #$1f          ;mod.pntr
t3dcmp   cmp start3,x
         bcs t3dlow
         dec start3,x
t3dlow   dex
         bpl t3dcmp
         sta e_orad
         tya
         tax
         ldy #$00
t3djst   lda (zp7),y
         cmp #$ff          ;jmp?
         bne t3djnx
         iny
         lda e_orad
         cmp (zp7),y
         bcs t3djnx-4
         lda (zp7),y
         sec
         sbc #$01
         sta (zp7),y
         cpy #$ff
         beq *+7
t3djnx   iny
         cpy #$ff
         bne t3djst
         txa
         tay
         jsr startw
         lda #$ff
         sec
         sbc zp9
         sta t3dcpy+1
t3delp   iny
         lda (zp7),y
         dey
         sta (zp7),y
         iny
t3dcpy   cpy #$00
         bne t3delp
t3dele   lda #$80
         sta (zp7),y
         pla
         tay
         pla
         tax
         jmp t3loop
t3uppp   cmp #$91
         bne t3inst
         cpy #$00
         bne t3uint
         lda zp9           ;scroll
         bne *+5
         jmp t3newc
         dec zp9
         jmp t3loop
t3uint   dey               ;down
         jmp t3loop
t3inst   cmp #$94
         bne t3left
         txa
         pha
         sty t3icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq t3inse
         ldx #$1f
t3icmp   cmp start3,x      ;mod.pntr
         beq t3ilow-3
         bcs t3ilow
         inc start3,x
t3ilow   dex
         bpl t3icmp
         sta e_orad
         ldy #$00
t3ijst   lda (zp7),y
         cmp #$ff          ;jmp?
         bne t3ijnx
         iny
         lda e_orad
         cmp (zp7),y
         beq *+4
         bcs t3ijnx-4
         lda (zp7),y
         clc
         adc #$01
         sta (zp7),y
         cpy #$ff
         beq *+7
t3ijnx   iny
         cpy #$ff
         bne t3ijst
         jsr startw
         lda #$ff
         sec
         sbc zp9
         tay
t3islp   dey
         lda (zp7),y
         iny
         sta (zp7),y
         dey
t3icpy   cpy #$00
         bne t3islp
t3inse   lda #$80
         sta (zp7),y
         pla
         tax
         jmp t3loop
t3left   cmp #$9d
         bne t3gsnd
         lda zp9
         sta e_tr3p
         lda e_tr2p
         sta zp9
         jmp t2loop
t3gsnd   cmp #$28          ;exit
         bcs t3font
         and #$07
         tay
         lda zp9
         sta e_tr3p
         jmp coltrs
t3font   cmp #$5c
         bne t3scrn
         tya
         clc
         adc zp9
         ldx e_tune
         sta start3,x
         sta zp9
         jsr chk_fa
         sta e_tr3p
         jsr startw
         jmp t3edit
t3scrn   cmp #$5f          ;to editor
         bne t3tr1x
         ldy #$00
         lda zp9
         sta e_tr3p
         jmp coltrs
t3tr1x   jsr keychk
         beq *+9
         cmp #$01
         bne t3sret
         jmp t3edit
         jmp t3newc
t3sret   cmp #$8d
         bne t3lett
         lda #$03
         sta e_ltrk
         lda (zp7),y
         cmp #$80
         bcc t3sre1
         cmp #$e0
         bcs t3sre1
         and #$7f
         sta e_sctn
t3sre1   ldy #$04
         lda zp9
         sta e_tr3p
         jmp coltrs
t3lett   cmp #$c4          ;sh.d
         bne *+6
         lda #$f1
         bne t3lcmd
         cmp #$c8          ;sh.h
         bne *+6
         lda #$f0
         bne t3lcmd
         cmp #$c9          ;sh.i
         bne *+6
         lda #$f8
         bne t3lcmd
         cmp #$ca          ;sh.j
         bne *+6
         lda #$ff
         bne t3lcmd
         cmp #$d3          ;sh.s
         bne *+6
         lda #$80
         bne t3lcmd
         cmp #$d6          ;sh.v
         bne *+6
         lda #$e0
         bne t3lcmd
         cmp #$2b          ;+
         beq *+6
         cmp #$db          ;sh.+
         bne *+6
         lda #$00
         beq t3lcmd
         cmp #$2d          ;-
         beq *+6
         cmp #$dd          ;sh.-
         bne t3numb
         lda #$40
t3lcmd   sta (zp7),y
         jmp t3newc-3
t3numb   cmp #$30          ;number
         bcc t3back
         cmp #$3a
         bcc t3back+3
         cmp #$41
         bcc t3back
         cmp #$47
         bcc t3back+3
t3back   jmp t3newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
         lda (zp7),y
         cmp #$ff          ;jmp
         bne *+8
         jsr jmpnum
         jmp t3newc-3
         cmp #$f8          ;inc
         bcc *+8
         jsr incnum
         jmp t3newc-3
         cmp #$f0          ;hlt
         beq t3back
         bcc *+8
         jsr decnum        ;dec
         jmp t3newc-3
         cmp #$e0          ;vol
         bcc *+8
         jsr volnum
         jmp t3newc-3
         cmp #$80          ;sct
         bcc *+8
         jsr sctnum
         jmp t3newc-3
         cmp #$40          ;tr-
         bcc *+8
         jsr trdnum
         jmp t3newc-3
         jsr trunum        ;tr+
         jmp t3newc-3

s__snd   asl a
         asl a
         asl a
         asl a
         ora #$c0
         ora e_orad
         sta (zp1),y
         and #$3f
         sta e_sndn
         rts
s__dur   sec
         sbc #$7f
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sec
         sbc #$01
         and #$3f
         clc
         adc #$80
         sta (zp1),y
         rts
s__gld   sec
         sbc #$5f
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sec
         sbc #$01
         and #$1f
         clc
         adc #$60
         sta (zp1),y
         rts

s_edit   ldy #$00
         sty zp9
s_loop   jsr coltrs
         ldx x_line,y
         lda #$01
         sta $d898,x
         sta $d899,x
         sta $d89a,x
         sta $d89b,x
         sta $d89c,x
         sta $d89d,x
s_csnd   jsr sctout
         lda (zp1),y
         cmp #$c0
         bcc *+7
         and #$3f
         sta e_sndn
         jsr sctlen
s_newc   jsr getkey
         cmp #$1d
         beq s_newc
         cmp #$20
         beq s_newc
         cmp #$0d
         bne s_down
         tya
         pha
         jsr coltrs
         ldy #$00
         lda zp2
         sta s_pbuf+2
s_pbuf   lda $7000,y
         sta $5700,y
         iny
         bne s_pbuf
         pla
         tay
         jmp s_loop
s_down   cmp #$11
         bne s_home
         cpy #$05
         bne s_dint
         lda zp9           ;scroll
         cmp #$fa
         beq s_newc
         inc zp9
         jmp s_loop
s_dint   iny               ;down
         jmp s_loop
s_home   cmp #$13
         beq s_edit
         cmp #$14
         bne s_uppp
         txa
         pha
         tya
         pha
         clc
         adc zp9
         cmp #$ff
         beq s_dele
         lda #$ff
         sec
         sbc zp9
         sta s_dcpy+1
s_delp   iny
         lda (zp1),y
         dey
         sta (zp1),y
         iny
s_dcpy   cpy #$00
         bne s_delp
s_dele   lda #$5f
         sta (zp1),y
         pla
         tay
         pla
         tax
         jmp s_loop
s_uppp   cmp #$91
         bne s_inst
         cpy #$00
         bne s_uint
         lda zp9           ;scroll
         bne *+5
         jmp s_newc
         dec zp9
         jmp s_loop
s_uint   dey               ;down
         jmp s_loop
s_inst   cmp #$94
         bne s_gsnd
         txa
         pha
         sty s_icpy+1
         tya
         clc
         adc zp9
         cmp #$ff
         beq s_inse
         lda #$ff
         sec
         sbc zp9
         tay
s_islp   dey
         lda (zp1),y
         iny
         sta (zp1),y
         dey
s_icpy   cpy #$00
         bne s_islp
s_inse   lda #$5f
         sta (zp1),y
         pla
         tax
         jmp s_loop
s_gsnd   cmp #$28          ;exit
         bcs s_dsct
         and #$07
         tay
         jmp coltrs
s_dsct   cmp #$3a
         bne s_isct
         lda e_sctn
         beq *+5
         dec e_sctn
         jmp s_loop
s_isct   cmp #$3b
         bne s_trup
         lda e_sctn
         cmp #$5f
         beq *+5
         inc e_sctn
         jmp s_loop
s_trup   cmp #$db
         bne s_trdn
         tya
         pha
         ldy #$00
s_tulo   lda (zp1),y
         cmp #$5e
         bcs *+6
         adc #$01
         sta (zp1),y
         iny
         bne s_tulo
         pla
         tay
         jmp s_loop
s_trdn   cmp #$dd
         bne s_arrw
         tya
         pha
         ldy #$00
s_tdlo   lda (zp1),y
         beq *+11
         cmp #$5f
         bcs *+7
         sec
         sbc #$01
         sta (zp1),y
         iny
         bne s_tdlo
         pla
         tay
         jmp s_loop
s_arrw   cmp #$5e
         bne s_scrn
         tya
         pha
         jsr coltrs
         ldy #$00
         lda zp2
         sta s_cbuf+5
s_cbuf   lda $5700,y
         sta $7000,y
         iny
         bne s_cbuf
         pla
         tay
         jmp s_loop
s_scrn   cmp #$5f          ;to editor
         bne s_tr1x
         ldy #$00
         jmp coltrs
s_tr1x   jsr keychk
         beq *+9
         cmp #$01
         bne s_sret
         jmp s_edit
         jmp s_newc
s_sret   cmp #$8d
         bne s_lett
         ldy e_ltrk
         jmp coltrs
s_lett   cmp #$c4          ;sh.d
         bne *+6
         lda #$80
         bne s_lcmd
         cmp #$c5          ;sh.e
         bne *+6
         lda #$7f
         bne s_lcmd
         cmp #$c7          ;sh.g
         bne *+6
         lda #$60
         bne s_lcmd
         cmp #$c8          ;sh.h
         bne *+6
         lda #$6f
         bne s_lcmd
         cmp #$d3          ;sh.s
         bne *+6
         lda #$c0
         bne s_lcmd
         cmp #$2d          ;-
         bne s_numb
         lda #$5f
s_lcmd   sta (zp1),y
         jmp s_csnd
s_numb   sta e_orad
         lda (zp1),y       ;cmd?
         cmp #$60
         bcc s_note
         cmp #$6f
         beq s_note
         cmp #$7f
         beq s_note
         lda e_orad
         cmp #$30          ;number
         bcc s_back
         cmp #$3a
         bcc s_back+3
         cmp #$41
         bcc s_back
         cmp #$47
         bcc s_back+3
s_back   jmp s_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
         lda (zp1),y
         cmp #$c0          ;snd.
         bcc *+8
         jsr s__snd
         jmp s_csnd
         cmp #$80          ;dur.
         bcc *+8
         jsr s__dur
         jmp s_csnd
         sta actdur
         lda e_orad        ;0?
         beq *+8
         lda actdur
         jsr s__gld        ;gld.
         jmp s_csnd
s_note   lda e_orad
         cmp #$31
         bcc s_back
         cmp #$39
         bcs s_keys
         and #$0f
         sec
         sbc #$01
         sta e_octv
         lda (zp1),y
s_nsbc   cmp #$0c
         bcc s_pure
         sec
         sbc #$0c
         jmp s_nsbc
s_keys   cmp #$41          ;c-
         bne *+6
         lda #$00
         beq s_pure
         cmp #$57          ;c#
         bne *+6
         lda #$01
         bne s_pure
         cmp #$53          ;d-
         bne *+6
         lda #$02
         bne s_pure
         cmp #$45          ;d#
         bne *+6
         lda #$03
         bne s_pure
         cmp #$44          ;e-
         bne *+6
         lda #$04
         bne s_pure
         cmp #$46          ;f-
         bne *+6
         lda #$05
         bne s_pure
         cmp #$54          ;f#
         bne *+6
         lda #$06
         bne s_pure
         cmp #$47          ;g-
         bne *+6
         lda #$07
         bne s_pure
         cmp #$59          ;g#
         bne *+6
         lda #$08
         bne s_pure
         cmp #$48          ;a-
         bne *+6
         lda #$09
         bne s_pure
         cmp #$55          ;a#
         bne *+6
         lda #$0a
         bne s_pure
         cmp #$4a          ;b-
         bne *+6
         lda #$0b
         bne s_pure
         cmp #$4b          ;c'
         beq *+5
         jmp s_newc
         lda #$0c
s_pure   ldx e_octv
         clc
         adc octave,x
         cmp #$5f
         bcc *+4
         lda #$5e
         sta (zp1),y
         sta e_test
         jsr spaces
         jmp s_loop

q_edit   ldx #$00
q_loop   ldy e_tune
         jsr f8_key+3
         jsr colsta
         lda #$01
         sta $da9e,x
         sta $da9f,x
q_newc   jsr getkey
         cmp #$0d
         bne q_down
         txa
         bmi q_edit
         ldx #$cb
         jmp q_loop
q_down   cmp #$11
         bne q_home
         txa
         bmi q_newc
         bne q_dwn2
         lda start1,y
         clc
         adc #$01
         sta start1,y
         jmp q_loop
q_dwn2   cpx #$03
         bne q_dwn3
         lda start2,y
         clc
         adc #$01
         sta start2,y
         jmp q_loop
q_dwn3   lda start3,y
         clc
         adc #$01
         sta start3,y
         jmp q_loop
q_home   cmp #$13
         beq q_edit
         cmp #$1d          ;right
         bne q_uppp
         cpx #$06
         beq q_newc
         cpx #$ce
         beq q_newc
         inx
         inx
         inx
         jmp q_loop
q_uppp   cmp #$91
         bne q_left
         txa
         bpl *+5
q_new2   jmp q_newc
         bne q_upp2
         lda start1,y
         sec
         sbc #$01
         sta start1,y
         jmp q_loop
q_upp2   cpx #$03
         bne q_upp3
         lda start2,y
         sec
         sbc #$01
         sta start2,y
         jmp q_loop
q_upp3   lda start3,y
         sec
         sbc #$01
         sta start3,y
         jmp q_loop
q_left   cmp #$9d
         bne q_gsnd
         txa
         beq q_new2
         cpx #$cb
         beq q_new2
         dex
         dex
         dex
         jmp q_loop
q_gsnd   cmp #$21
         bcc q_new2
         cmp #$28          ;exit
         bcs q_scrn
         and #$07
         tay
         jmp colsta
q_scrn   cmp #$5f          ;to editor
         bne q_tr1x
         ldy #$00
         jmp colsta
q_tr1x   jsr keychk
         beq *+9
         cmp #$01
         bne q_numb
         jmp q_loop
         jmp q_newc
q_numb   cmp #$30
         bcc q_back
         cmp #$3a
         bcc q_back+3
         cmp #$41
         bcc q_back
         cmp #$47
         bcc q_back+3
q_back   jmp q_newc
         cmp #$40
         bcc *+5
         sec
         sbc #$07
         and #$0f
         sta e_orad
         txa
         bpl q_setn
         cpx #$cb
         beq q_inde
         lda e_orad
         cmp #$0a
         bcs q_back
         ldy e_tune
         sta speeds,y
         jmp q_loop
q_inde   tya
         asl a
         asl a
         asl a
         asl a
         and #$1f
         ora e_orad
         sta e_tune
         tay
         jmp q_loop
q_setn   bne q_set2
         lda start1,y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sta start1,y
         jmp q_loop
q_set2   cpx #$03
         bne q_set3
         lda start2,y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sta start2,y
         jmp q_loop
q_set3   lda start3,y
         asl a
         asl a
         asl a
         asl a
         ora e_orad
         sta start3,y
         jmp q_loop


         *= $3b9e

len_lo   .byte $00
len_hi   .byte $00
actdur   .byte $00
e_tune   .byte $00         ;tune#
e_acts   .byte $00         ;speed
e_sctn   .byte $00         ;sct.#
e_ltrk   .byte $01         ;last trk
e_octv   .byte $00         ;octave
e_tr1p   .byte $00         ;trk.pos
e_tr2p   .byte $00
e_tr3p   .byte $00
e_tr1x   .byte $7a         ;trk.on
e_tr2x   .byte $7a
e_tr3x   .byte $7a
e_msg1   .byte $00         ;message
e_msg2   .byte $00
e_msg3   .byte $00
e_gldp   .byte $00         ;gld.pos
e_sndn   .byte $00         ;snd.#
e_spos   .byte $00         ;sretpos
e_test   .byte $00         ;t.note
e_radd   .byte $00
e_ract   .byte $00
e_rmax   .byte $00
e_clkt   .byte $00         ;timing
e_secs   .byte $00         ;clock sec
e_mins   .byte $00         ;clock min
e_orad   .byte $00         ;ora-reg

call1s   .byte LO(call_1),LO(call_2),LO(call_2)
         .byte LO(call_2),LO(call_2),LO(call_2)
         .byte LO(call_2),LO(call_2),LO(call_2)
         .byte LO(call_2)
call2s   .byte $00,LO(call_1),LO(call_3)
         .byte LO(call_3),LO(call_3),LO(call_3)
         .byte LO(call_3),LO(call_3),LO(call_3)
         .byte LO(call_3)
call3s   .byte $00,$00,LO(call_1),LO(call_4)
         .byte LO(call_4),LO(call_4),LO(call_4)
         .byte LO(call_4),LO(call_4),LO(call_4)
call4s   .byte $00,$00,$00,LO(call_1)
         .byte LO(call_5),LO(call_5),LO(call_5)
         .byte LO(call_5),LO(call_5),LO(call_5)
call5s   .byte $00,$00,$00,$00,LO(call_1)
         .byte LO(call_6),LO(call_6),LO(call_6)
         .byte LO(call_6),LO(call_6)
call6s   .byte $00,$00,$00,$00,$00
         .byte LO(call_1),LO(call_7),LO(call_7)
         .byte LO(call_7),LO(call_7)
call7s   .byte $00,$00,$00,$00,$00,$00
         .byte LO(call_1),LO(call_8),LO(call_8)
         .byte LO(call_8)
call8s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,LO(call_1),LO(call_9)
         .byte LO(call_9)
call9s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,LO(call_1),LO(call_0)
call0s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,LO(call_1)

call1r   .byte $46,$d8,$8e,$66,$4f,$4a
         .byte $3c,$3a,$36,$2e
call2r   .byte $00,$42,$f0,$b0,$88,$76
         .byte $62,$5a,$52,$48
call3r   .byte $00,$00,$2c,$fa,$c1,$a2
         .byte $88,$7a,$6e,$62
call4r   .byte $00,$00,$00,$1c,$fa,$ce
         .byte $ae,$9a,$8a,$7c
call5r   .byte $00,$00,$00,$00,$0e,$fa
         .byte $d4,$ba,$a6,$96
call6r   .byte $00,$00,$00,$00,$00,$0a
         .byte $fa,$da,$c2,$b0
call7r   .byte $00,$00,$00,$00,$00,$00
         .byte $16,$fa,$de,$ca
call8r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$14,$fa,$e4
call9r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$10,$fe
call0r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$08

call1j   .byte $31,$81,$81,$81,$81,$81
         .byte $81,$81,$81,$81
call2j   .byte $00,$31,$81,$81,$81,$81
         .byte $81,$81,$81,$81
call3j   .byte $00,$00,$31,$81,$81,$81
         .byte $81,$81,$81,$81
call4j   .byte $00,$00,$00,$31,$81,$81
         .byte $81,$81,$81,$81
call5j   .byte $00,$00,$00,$00,$31,$81
         .byte $81,$81,$81,$81
call6j   .byte $00,$00,$00,$00,$00,$31
         .byte $81,$81,$81,$81
call7j   .byte $00,$00,$00,$00,$00,$00
         .byte $31,$81,$81,$81
call8j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$31,$81,$81
call9j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$31,$81
call0j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$31

fncadl   .byte LO(fnctxt)+$00,LO(fnctxt)+$12
         .byte LO(fnctxt)+$24,LO(fnctxt)+$36
         .byte LO(fnctxt)+$48,LO(fnctxt)+$5a
         .byte LO(fnctxt)+$6c,LO(fnctxt)+$7e
         .byte LO(fnctxt)+$90,LO(fnctxt)+$a2
         .byte LO(fnctxt)+$b4,LO(fnctxt)+$c6
         .byte LO(fnctxt)+$d8,LO(fnctxt)+$ea
         .byte LO(fnctxt)+$fc,LO(fnctxt)+$0e
         .byte LO(fnctxt)+$20,LO(fnctxt)+$32

fncadh   .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01

rstart   .byte $46,$42,$2c,$1c,$0e,$0a
         .byte $16,$14,$10,$08
etrack   .byte $00,$80,$ff,$01
ttrack   .byte $00,$df,$ff,$01
x_line   .byte $00,$28,$50,$78
         .byte $a0,$c8,$00,$00
octave   .byte $00,$0c,$18,$24
         .byte $30,$3c,$48,$54
twelve   .text "c-c#d-d#e-f-"
         .text "f#g-g#a-a#b-"
sc_snd   .text "snd.  "
sc_dur   .text "dur.  "
sc_gld   .text "gld.  "
sc_end   .text "-end!-"
sc_hld   .text "-hold-"
sc_rst   .text "------"
tr_tup   .byte $54,$12,$2b,$20,$20  ;"Tr+  "
tr_tdn   .byte $54,$12,$2d,$20,$20  ;"Tr-  "
tr_sct   .byte $53,$03,$14,$20,$20  ;"Sct  "
tr_vol   .byte $56,$0f,$0c,$20,$20  ;"Vol  "
tr_hlt   .byte $48,$0c,$14,$56,$50  ;"HltVP"
tr_dec   .byte $44,$05,$03,$20,$20  ;"Dec  "
tr_inc   .byte $49,$0e,$03,$20,$20  ;"Inc  "
tr_jmp   .byte $4a,$0d,$10,$20,$20  ;"Jmp  "

fnctxt   .byte $41,$14,$14,$01,$03,$0b  ;"Attack + Decay    "
         .byte $20,$2b,$20,$44,$05,$03
         .byte $01,$19,$20,$20,$20,$20
         .byte $53,$15,$13,$14,$01,$09  ;"Sustain + Release "
         .byte $0e,$20,$2b,$20,$52,$05
         .byte $0c,$05,$01,$13,$05,$20
         .byte $47,$01,$14,$05,$20,$0f  ;"Gate off counter  "
         .byte $06,$06,$20,$03,$0f,$15
         .byte $0e,$14,$05,$12,$20,$20
         .byte $41,$12,$10,$05,$07,$07  ;"Arpeggio pointer  "
         .byte $09,$0f,$20,$10,$0f,$09
         .byte $0e,$14,$05,$12,$20,$20
         .byte $46,$09,$0c,$14,$05,$12  ;"Filter pointer    "
         .byte $20,$10,$0f,$09,$0e,$14
         .byte $05,$12,$20,$20,$20,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse pointer     "
         .byte $10,$0f,$09,$0e,$14,$05
         .byte $12,$20,$20,$20,$20,$20
         .byte $53,$0c,$09,$04,$05,$20  ;"Slide pointer     "
         .byte $10,$0f,$09,$0e,$14,$05
         .byte $12,$20,$20,$20,$20,$20
         .byte $57,$01,$16,$05,$06,$0f  ;"Waveform / Command"
         .byte $12,$0d,$20,$2f,$20,$43
         .byte $0f,$0d,$0d,$01,$0e,$04
         .byte $41,$12,$10,$05,$07,$07  ;"Arpeggio steps    "
         .byte $09,$0f,$20,$13,$14,$05
         .byte $10,$13,$20,$20,$20,$20
         .byte $52,$05,$10,$05,$01,$14  ;"Repeat / Command  "
         .byte $20,$2f,$20,$43,$0f,$0d
         .byte $0d,$01,$0e,$04,$20,$20
         .byte $46,$12,$05,$11,$15,$05  ;"Frequency low     "
         .byte $0e,$03,$19,$20,$0c,$0f
         .byte $17,$20,$20,$20,$20,$20
         .byte $46,$12,$05,$11,$15,$05  ;"Frequency high    "
         .byte $0e,$03,$19,$20,$08,$09
         .byte $07,$08,$20,$20,$20,$20
         .byte $52,$05,$13,$0f,$0e,$01  ;"Resonance + F.low "
         .byte $0e,$03,$05,$20,$2b,$20
         .byte $46,$2e,$0c,$0f,$17,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse width low   "
         .byte $17,$09,$04,$14,$08,$20
         .byte $0c,$0f,$17,$20,$20,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse width high  "
         .byte $17,$09,$04,$14,$08,$20
         .byte $08,$09,$07,$08,$20,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 1 startpos. "
         .byte $31,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 2 startpos. "
         .byte $32,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 3 startpos. "
         .byte $33,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20

filnam   .text "            "
         .text "             "
msg_ld   .byte $50,$0c,$05,$01,$13,$05  ;"Please wait,"
         .byte $20,$17,$01,$09,$14,$2c
         .byte $20,$0c,$0f,$01,$04,$09  ;" loading...  "
         .byte $0e,$07,$2e,$2e,$2e,$20
         .byte $20
msg_sv   .byte $50,$0c,$05,$01,$13,$05  ;"Please wait,"
         .byte $20,$17,$01,$09,$14,$2c
         .byte $20,$13,$01,$16,$09,$0e  ;" saving...   "
         .byte $07,$2e,$2e,$2e,$20,$20
         .byte $20
msg_np   .byte $44,$05,$16,$09,$03,$05  ;"Device 8 not"
         .byte $20,$38,$20,$0e,$0f,$14
         .byte $20,$10,$12,$05,$13,$05  ;" present     "
         .byte $0e,$14,$20,$20,$20,$20
         .byte $20
msg_pl   .byte $55,$0e,$09,$04,$05,$0e  ;"Unidentified"
         .byte $14,$09,$06,$09,$05,$04
         .byte $20,$10,$0c,$01,$19,$05  ;" player      "
         .byte $12,$20,$20,$20,$20,$20
         .byte $20

;---------------------------------------
.end
