;---------  SIDwinder V01.20  ----------
#include op.asm

         *= $0c00

zp1      = $2b             ;1st col
zp2      = $2c
zp3      = $2d             ;2nd col
zp4      = $2e
zp5      = $2f             ;3rd col
zp6      = $30
zp7      = $31             ;sct.len
zp8      = $32
zp9      = $33             ;corner pos

ctinit   = $45fc
volume   = $46bd
dur_dc   = $4653
dur_rs   = $4654
gt_dec   = $464e
trk_lo   = $4664
trk_hi   = $4665
trkpos   = $4666
sctpos   = $4669
f_type   = $46bb
s_nmbr   = $46a7
w_pntr   = $4691
offset   = $46c2

speeds   = $4700
start1   = $4720
start2   = $4740
start3   = $4760

tr1adl   = $4780
tr2adl   = $47a0
tr3adl   = $47c0
tr1adh   = $47e0
tr2adh   = $4800
tr3adh   = $4820

gld_al   = $4840
gld_ah   = $4850

sctadl   = $4880
sctadh   = $48e0

snd_ad   = $4940           ;i_edit!
snd_sr   = $4980
snd_gt   = $49c0
snd_wt   = $4a00
snd_ft   = $4a40
snd_pt   = $4a80
snd_st   = $4ac0

wve_fm   = $4b00
wve_st   = $4c00

flt_rp   = $4d00
flt_fh   = $4e00
flt_rl   = $4f00

pls_rp   = $5000
pls_pl   = $5100
pls_ph   = $5200

sld_rp   = $5300
sld_fl   = $5400
sld_fh   = $5500


         jmp m_entp

call_1   sei
         lda #$01
         sta $d019
calls1   = *+1
         ldy #$00
callr1   = *+1
         lda #$00
         jsr jp1003
         cli
callj1   = *+1
         jmp $ea81
call_2   sei
         lda #$01
         sta $d019
calls2   = *+1
         ldy #$00
callr2   = *+1
         lda #$00
         jsr jp1006
         cli
callj2   = *+1
         jmp $ea81
call_3   sei
         lda #$01
         sta $d019
calls3   = *+1
         ldy #$00
callr3   = *+1
         lda #$00
         jsr jp1006
         cli
callj3   = *+1
         jmp $ea81
call_4   sei
         lda #$01
         sta $d019
calls4   = *+1
         ldy #$00
callr4   = *+1
         lda #$00
         jsr jp1006
         cli
callj4   = *+1
         jmp $ea81
call_5   sei
         lda #$01
         sta $d019
calls5   = *+1
         ldy #$00
callr5   = *+1
         lda #$00
         jsr jp1006
         cli
callj5   = *+1
         jmp $ea81
call_6   sei
         lda #$01
         sta $d019
calls6   = *+1
         ldy #$00
callr6   = *+1
         lda #$00
         jsr jp1006
         cli
callj6   = *+1
         jmp $ea81
call_7   sei
         lda #$01
         sta $d019
calls7   = *+1
         ldy #$00
callr7   = *+1
         lda #$00
         jsr jp1006
         cli
callj7   = *+1
         jmp $ea81
call_8   sei
         lda #$01
         sta $d019
calls8   = *+1
         ldy #$00
callr8   = *+1
         lda #$00
         jsr jp1006
         cli
callj8   = *+1
         jmp $ea81
call_9   sei
         lda #$01
         sta $d019
calls9   = *+1
         ldy #$00
callr9   = *+1
         lda #$00
         jsr jp1006
         cli
callj9   = *+1
         jmp $ea81
call_0   sei
         lda #$01
         sta $d019
calls0   = *+1
         ldy #$00
callr0   = *+1
         lda #$00
         jsr jp1006
         cli
callj0   = *+1
         jmp $ea31

callno   sei               ;stopped
         lda #$01
         sta $d019
         lda #$fa
         sta $d012
         cli
         jmp $ea31

jp1003   sta $d012         ;1st
         sty $0314
         dec $d020
         lda #$f1
         sta irqpnt+1
         lda #$06
         sta irqpnt+2
         lda e_radd
         cmp e_rmax
         bcc notrec
         sta e_rmax
         ldx #$03          ;max.rtime
         jsr irqout
         lda e_radd
notrec   ldx #$00          ;act.rtime
         jsr irqout
         lda $d012
         sta e_ract
         jsr $4003
         lda $d012
         sec
         sbc e_ract
         sta e_radd
         inc $d020
         lda #$00
         ldx #$7a
         cpx e_tr1x        ;trk1 off?
         beq *+5
         sta w_pntr
         cpx e_tr2x        ;trk2 off?
         beq *+5
         sta w_pntr+$07
         cpx e_tr3x        ;trk3 off?
         beq *+5
         sta w_pntr+$0e
         dec e_clkt        ;time
         bne notsec
         lda #$32          ;50 frames
         sta e_clkt
         lda #$19
         sta irqpnt+1
         lda #$07
         sta irqpnt+2
         lda e_secs
         sed
         clc
         adc #$01          ;inc secs
         cmp #$60
         beq yesmin
         sta e_secs
         cld
         jmp yessec
yesmin   lda #$00          ;1 min
         sta e_secs
         lda e_mins
         clc
         adc #$01          ;inc mins
         cmp #$60
         bne notmin
         lda #$00          ;1 hour
notmin   sta e_mins
         cld
         ldx #$00
         jsr irqout
         lda e_secs
yessec   ldx #$03
         jsr irqout
notsec   lda e_acts        ;a.speed
         cmp #$06
         bcc wdatas
         rts
wdatas   lda #$be          ;max 6x
         sta irqpnt+1
         lda #$05
         sta irqpnt+2
         lda trkpos        ;trk
         sec
         sbc #$01
         ldx #$00
         jsr irqout
         lda trkpos+$07
         sec
         sbc #$01
         ldx #$03
         jsr irqout
         lda trkpos+$0e
         sec
         sbc #$01
         ldx #$06
         jsr irqout
         lda dur_rs        ;dur
         clc
         adc #$01
         ldx #$0f
         jsr irqout
         lda dur_rs+$07
         clc
         adc #$01
         ldx #$12
         jsr irqout
         lda dur_rs+$0e
         clc
         adc #$01
         ldx #$15
         jsr irqout
         lda sctpos        ;sct
         ldx #$28
         jsr irqout
         lda sctpos+$07
         ldx #$2b
         jsr irqout
         lda sctpos+$0e
         ldx #$2e
         jsr irqout
         lda dur_dc        ;act
         ldx #$37
         jsr irqout
         lda dur_dc+$07
         ldx #$3a
         jsr irqout
         lda dur_dc+$0e
         ldx #$3d
         jsr irqout
         lda s_nmbr        ;snd
         ldx #$50
         jsr irqout
         lda s_nmbr+$07
         ldx #$53
         jsr irqout
         lda s_nmbr+$0e
         ldx #$56
         jsr irqout
         lda gt_dec        ;off
         ldx #$5f
         jsr irqout
         lda gt_dec+$07
         ldx #$62
         jsr irqout
         lda gt_dec+$0e
         ldx #$65
         jmp irqout

jp1006   sta $d012         ;multi
         sty $0314
         dec $d020
         lda $d012
         sta e_ract
         jsr $4006
         lda $d012
         sec
         sbc e_ract
         clc
         adc e_radd
         sta e_radd
         inc $d020
         rts

setspd   ldy e_tune
         lda speeds,y
         sta e_acts
         tay
         lda call1s,y
         sta calls1
         lda call1r,y
         sta callr1
         lda call1j,y
         sta callj1
         lda call2s,y
         sta calls2
         lda call2r,y
         sta callr2
         lda call2j,y
         sta callj2
         lda call3s,y
         sta calls3
         lda call3r,y
         sta callr3
         lda call3j,y
         sta callj3
         lda call4s,y
         sta calls4
         lda call4r,y
         sta callr4
         lda call4j,y
         sta callj4
         lda call5s,y
         sta calls5
         lda call5r,y
         sta callr5
         lda call5j,y
         sta callj5
         lda call6s,y
         sta calls6
         lda call6r,y
         sta callr6
         lda call6j,y
         sta callj6
         lda call7s,y
         sta calls7
         lda call7r,y
         sta callr7
         lda call7j,y
         sta callj7
         lda call8s,y
         sta calls8
         lda call8r,y
         sta callr8
         lda call8j,y
         sta callj8
         lda call9s,y
         sta calls9
         lda call9r,y
         sta callr9
         lda call9j,y
         sta callj9
         lda call0s,y
         sta calls0
         lda call0r,y
         sta callr0
         lda call0j,y
         sta callj0
         lda rstart,y
         rts

getkey   lda #$00
         sta $c6
         lda $c6
         beq *-2
         lda $0277
         cmp #$0d          ;return
         beq accept
         cmp #$11          ;c.down
         beq accept
         cmp #$13          ;home
         beq accept
         cmp #$14          ;delete
         beq accept
         cmp #$1d          ;c.right
         beq accept
         cmp #$91          ;c.up
         beq accept
         cmp #$94          ;insert
         beq accept
         cmp #$9d          ;c.left
         beq accept
         cmp #$c4          ;sh.d
         beq accept
         cmp #$c5          ;sh.e
         beq accept
         cmp #$c7          ;sh.g
         beq accept
         cmp #$c8          ;sh.h
         beq accept
         cmp #$c9          ;sh.i
         beq accept
         cmp #$ca          ;sh.j
         beq accept
         cmp #$d3          ;sh.s
         beq accept
         cmp #$d6          ;sh.v
         beq accept
         cmp #$db          ;sh.+
         beq accept
         cmp #$dd          ;sh.-
         beq accept
         cmp #$20
         bcc getkey
         cmp #$8e
         bcs getkey
         cmp #$60
         bcc accept
         cmp #$85
         bcc getkey
accept   rts

irqout   ldy $0429
         cpy #$54
         bne irqpnt+3
         pha               ;hex #
         lsr a
         lsr a
         lsr a
         lsr a
         dex
         jsr irqcnv
         pla
         and #$0f
irqcnv   ora #$30
         inx
         cmp #$3a
         bcc irqpnt
         clc
         adc #$07
irqpnt   sta $face,x
         rts

numout   pha               ;hex #
         lsr a
         lsr a
         lsr a
         lsr a
         dex
         jsr numcnv
         pla
         and #$0f
numcnv   ora #$30
         inx
         cmp #$3a
         bcc numpnt
         clc
         adc #$07
numpnt   sta $face,x
         rts

fncout   sta fncnum+1      ;function
         lda $0429
         cmp #$54
         beq fncend
         tya
         pha
fncnum   ldy #$00
         lda fncadl,y
         sta fncpnt+1
         lda fncadh,y
         sta fncpnt+2
         ldy #$11
fncpnt   lda $face,y
         sta $043c,y
         dey
         bpl fncpnt
         pla
         tay
fncend   rts

colsnd   tya               ;snd.
         pha
         ldy #$27
         lda #$0f
collp1   sta $d878,y
         dey
         bpl collp1
         pla
         tay
         rts

colafp   tya               ;arp+flt+pls
         pha
         ldy #$ff
         lda #$0f
collp2   sta $d940,y
         dey
         bne collp2
         pla
         tay
         rts

coltrs   tya               ;trk+sct
         pha
         ldy #$ff
         lda #$0f
collp3   sta $d878,y
         dey
         bne collp3
         pla
         tay
         rts

colsta   tya               ;trst.
         pha
         ldy #$07
         lda #$0f
collp4   sta $da9e,y
         dey
         bpl collp4
         ldy #$04
collp5   sta $db69,y
         dey
         bpl collp5
         pla
         tay
         rts

colgld   tya               ;gld+more
         pha
         ldy #$ff
         lda #$0f
collp6   sta $dad0,y
         dey
         bne collp6
         pla
         tay
         rts

sndtab   txa               ;tables
         pha
         tya
         pha
         lda zp9
         pha
         lda #$2f
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_sndn
         ldx #$00
         tya               ;#
         jsr numout
         lda #$82
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldx #$00
         lda snd_ad,y      ;ad
         jsr numout
         ldx #$03
         lda snd_sr,y      ;sr
         jsr numout
         ldx #$06
         lda snd_gt,y      ;gt
         jsr numout
         ldx #$09
         lda snd_wt,y      ;wt
         jsr numout
         ldx #$0c
         lda snd_ft,y      ;ft
         jsr numout
         ldx #$0f
         lda snd_pt,y      ;pt
         jsr numout
         ldx #$12
         lda snd_st,y      ;st
         jsr numout
         lda e_test        ;note
         ldy #$08
notest   dey
         cmp octave,y
         bcc notest
         sbc octave,y      ;c=1
         asl a
         tax
         lda twelve,x
         sta $047e
         lda twelve+1,x
         sta $047f
         iny
         tya
         ora #$30
         sta $0480
         pla
         sta zp9
         pla
         tay
         pla
         tax
         rts

chk_fa   lda zp9
         cmp #$fb
         bcc *+6
         lda #$fa
         sta zp9
         rts

wvetab   jsr chk_fa
         lda #LO(wve_fm)
         clc
         adc zp9
         sta zp1
         lda #HI(wve_fm)
         sta zp2
         lda #LO(wve_st)
         clc
         adc zp9
         sta zp3
         lda #HI(wve_st)
         sta zp4
         lda #$00
         sta zp5
         sta zp6
         lda #$42
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

flttab   jsr chk_fa
         lda #LO(flt_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(flt_rp)
         sta zp2
         lda #LO(flt_fh)
         clc
         adc zp9
         sta zp3
         lda #HI(flt_fh)
         sta zp4
         lda #LO(flt_rl)
         clc
         adc zp9
         sta zp5
         lda #HI(flt_rl)
         sta zp6
         lda #$4d
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

plstab   jsr chk_fa
         lda #LO(pls_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(pls_rp)
         sta zp2
         lda #LO(pls_ph)
         clc
         adc zp9
         sta zp3
         lda #HI(pls_ph)
         sta zp4
         lda #LO(pls_pl)
         clc
         adc zp9
         sta zp5
         lda #HI(pls_pl)
         sta zp6
         lda #$5b
         sta numpnt+1
         lda #$05
         sta numpnt+2
         jmp tblout

gldtab   lda #LO(gld_ah)
         clc
         adc zp9
         sta zp1
         lda #HI(gld_ah)
         adc #$00
         sta zp2
         lda #LO(gld_al)
         clc
         adc zp9
         sta zp3
         lda #HI(gld_al)
         adc #$00
         sta zp4
         lda #$00
         sta zp5
         sta zp6
         lda #$d2
         sta numpnt+1
         lda #$06
         sta numpnt+2
         jmp tblout

sldtab   jsr chk_fa
         lda #LO(sld_rp)
         clc
         adc zp9
         sta zp1
         lda #HI(sld_rp)
         sta zp2
         lda #LO(sld_fh)
         clc
         adc zp9
         sta zp3
         lda #HI(sld_fh)
         sta zp4
         lda #LO(sld_fl)
         clc
         adc zp9
         sta zp5
         lda #HI(sld_fl)
         sta zp6
         lda #$dd
         sta numpnt+1
         lda #$06
         sta numpnt+2
         jmp tblout

trstab   lda #LO(start1)
         clc
         adc zp9
         sta zp1
         lda #HI(start1)
         adc #$00
         sta zp2
         lda #LO(start2)
         clc
         adc zp9
         sta zp3
         lda #HI(start2)
         adc #$00
         sta zp4
         lda #LO(start3)
         clc
         adc zp9
         sta zp5
         lda #HI(start3)
         adc #$00
         sta zp6
         lda #$eb
         sta numpnt+1
         lda #$06
         sta numpnt+2

tblout   txa               ;write
         pha
         tya
         pha
         ldy #$05
loop01   ldx x_line,y
         tya
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp1),y
         jsr numout
         inx
         inx
         lda (zp3),y
         jsr numout
         lda zp6
         beq twocol
         inx
         inx
         lda (zp5),y
         jsr numout
twocol   dey
         bpl loop01
         pla
         tay
         pla
         tax
         rts

sctout   txa               ;sector
         pha
         tya
         pha
         lda #$4c
         sta numpnt+1
         lda #$04
         sta numpnt+2
         lda e_sctn
         ldx #$00
         jsr numout
         ldx e_sctn
         lda sctadl,x
         clc
         adc zp9
         sta zp1
         lda sctadh,x
         adc #$00
         sta zp2
         lda #$95
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy #$05          ;sct.out
loop02   ldx x_line,y
         tya
         pha
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp1),y
         cmp #$c0
         bcc nossnd
         and #$3f
         pha
         lda #LO(sc_snd)
         ldy #HI(sc_snd)
seclin   sta sndwrt+1
         sty sndwrt+2
         ldy #$00
sndwrt   lda $face,y
         sta $0495,x       ;sector
         inx
         iny
         cpy #$04
         bne sndwrt
         pla
         jsr numout
loop03   pla
         tay
         dey
         bpl loop02
         pla
         tay
         pla
         tax
         rts
nossnd   cmp #$80
         bcc nosdur
         sbc #$7f
         pha
         lda #LO(sc_dur)
         ldy #HI(sc_dur)
         jmp seclin
nosdur   cmp #$7f
         bne nosend
         lda #LO(sc_end)
         ldy #HI(sc_end)
fullin   sta fullwt+1
         sty fullwt+2
         ldy #$00
fullwt   lda $face,y
         sta $0495,x
         inx
         iny
         cpy #$06
         bne fullwt
         jmp loop03
nosend   cmp #$6f
         bne nohold
         lda #LO(sc_hld)
         ldy #HI(sc_hld)
         jmp fullin
nohold   cmp #$5f
         bne norest
         lda #LO(sc_rst)
         ldy #HI(sc_rst)
         jmp fullin
norest   cmp #$60
         bcc nosgld
         and #$1f
         clc
         adc #$01
         pha
         lda #LO(sc_gld)
         ldy #HI(sc_gld)
         jmp seclin
nosgld   ldy #$08
         dey
         cmp octave,y
         bcc nosgld+2
         sbc octave,y      ;c=1
         asl a
         pha
         iny
         tya
         ora #$30
         sta $0498,x
         lda #$20
         sta $0495,x
         sta $0499,x
         sta $049a,x
         pla
         tay
         lda twelve,y
         sta $0496,x
         lda twelve+1,y
         sta $0497,x
         jmp loop03

sctlen   txa               ;length
         pha
         tya
         pha
         ldy e_sctn
         lda sctadl,y
         sta zp7
         lda sctadh,y
         sta zp8
         lda #$29
         sta numpnt+1
         lda #$06
         sta numpnt+2
         ldy #$00
         sty len_lo
         sty len_hi
         sty actdur
         beq sctcmd
skip_2   iny
         beq sctend
skip_1   iny
         beq sctend
sctcmd   lda (zp7),y
         cmp #$60
         bcs nonote
adddur   lda len_lo
         clc
         adc actdur
         sta len_lo
         bcc skip_1
         inc len_hi
         jmp skip_1
nonote   cmp #$6f
         beq adddur
         bcc skip_2
         cmp #$7f
         beq sctend
         cmp #$c0
         bcs skip_1
         sec
         sbc #$7f
         sta actdur
         jmp skip_1
sctend   ldx #$02
         lda len_lo
         jsr numout
         ldx #$00
         lda len_hi
         jsr numout
         pla
         tay
         pla
         tax
         rts

tr1out   txa               ;tracks
         pha
         tya
         pha
         jsr chk_fa
         lda #$79
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr1adl,y
         clc
         adc zp9
         sta zp7
         lda tr1adh,y
         adc #$00
         sta zp8
         jmp trkout

tr2out   txa
         pha
         tya
         pha
         jsr chk_fa
         lda #$82
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr2adl,y
         clc
         adc zp9
         sta zp7
         lda tr2adh,y
         adc #$00
         sta zp8
         jmp trkout

tr3out   txa
         pha
         tya
         pha
         jsr chk_fa
         lda #$8b
         sta trkwrt+4
         sta numpnt+1
         lda #$04
         sta numpnt+2
         ldy e_tune
         lda tr3adl,y
         clc
         adc zp9
         sta zp7
         lda tr3adh,y
         adc #$00
         sta zp8

trkout   ldy #$00
         ldx x_line,y
         tya
         pha
         clc
         adc zp9
         jsr numout
         inx
         inx
         lda (zp7),y
         cmp #$40
         bcs nottup
         pha
         lda #LO(tr_tup)
         ldy #HI(tr_tup)
trklin   sta trkwrt+1
         sty trkwrt+2
         ldy #$00
trkwrt   lda $face,y
         sta $0400,x
         inx
         iny
         cpy #$05
         bne trkwrt
         pla
         cmp #$ff
         beq nonumb
         dex
         dex
         jsr numout
nonumb   pla
         tay
         iny
         cpy #$06
         bne trkout+2
         dec zp7           ;top space
         ldy #$00
         lda (zp7),y
         inc zp7
         cmp #$ff
         bne nextra
         lda trkwrt+4
         sta cextra+1
         ldx #$07
         lda #$20
cextra   sta $0400,x
         dex
         bpl cextra
nextra   pla
         tay
         pla
         tax
         rts
nottup   cmp #$80
         bcs nottdn
         and #$3f
         pha
         lda #LO(tr_tdn)
         ldy #HI(tr_tdn)
         jmp trklin
nottdn   cmp #$e0
         bcs notsct
         and #$7f
         pha
         lda #LO(tr_sct)
         ldy #HI(tr_sct)
         jmp trklin
notsct   cmp #$f0
         beq haltvp
         bcs notvol
         and #$0f
         pha
         lda #LO(tr_vol)
         ldy #HI(tr_vol)
         jmp trklin
haltvp   lda #$ff
         pha
         lda #LO(tr_hlt)
         ldy #HI(tr_hlt)
         jmp trklin
notvol   cmp #$f8
         bcs notdec
         and #$0f
         pha
         lda #LO(tr_dec)
         ldy #HI(tr_dec)
         jmp trklin
notdec   cmp #$ff
         bcs notinc
         sec
         sbc #$f7
         pha
         lda #LO(tr_inc)
         ldy #HI(tr_inc)
         jmp trklin
notinc   cpy #$05
         beq skpclr
         txa
         pha
         clc
         adc trkwrt+4
         sta afterj+1
         lda trkwrt+5
         adc #$00
         sta afterj+2
         ldx #$25
         lda #$20
afterj   sta $face,x
         inx
         cpx #$2d
         bne afterj
         pla
         tax
         pla               ;y=y+1
         clc
         adc #$01
         pha
skpclr   iny
         lda (zp7),y
         pha
         lda #LO(tr_jmp)
         ldy #HI(tr_jmp)
         jmp trklin

f1_key   sei               ;play
         txa
         pha
         tya
         pha
         lda #$00
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda #$80
         sta ttrack+1
         lda e_tune
         jsr $4000
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

f2_key   sei               ;sector
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda e_sctn
         ora #$80
         sta ttrack+1
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

f3_key   sei               ;stop
         lda #LO(callno)
         sta $0314
         lda #HI(callno)
         sta $0315
         lda #$80
         sta ttrack+1
         lda #$fa
         sta $d012
         lda #$00
         sta $d418
         cli
         rts

f4_key   sei               ;sfx
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         sta e_radd
         sta e_ract
         sta e_rmax
         sta e_secs
         sta e_mins
         lda #$32
         sta e_clkt
         lda $0429
         cmp #$54
         bne *+16          ;sounds s.
         lda #$30
         sta $0719         ;clock
         sta $071a
         sta $071c
         sta $071d
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda #$df          ;sct.#
         sta ttrack+1
         lda e_sndn        ;snd.#
         ora #$c0
         sta $cf00
         lda e_test        ;note
         sta $cf02
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

spaces   lda $0314         ;sfx on?
         cmp #LO(callno)
         beq spcend
         lda ttrack+1
         cmp #$df
         bne spcend
         sei
         txa
         pha
         tya
         pha
         lda #$00
         sta trkpos
         sta trkpos+$07
         sta trkpos+$0e
         lda e_sndn        ;snd.#
         ora #$c0
         sta $cf00
         lda e_test        ;note
         sta $cf02
         lda #LO(ttrack)      ;mod.init
         sta trk_lo
         lda #HI(ttrack)
         sta trk_hi
         lda #LO(etrack)
         sta trk_lo+$07
         sta trk_lo+$0e
         lda #HI(etrack)
         sta trk_hi+$07
         sta trk_hi+$0e
         jsr ctinit
         pla
         tay
         pla
         tax
spcend   lda #$00
         cli
         rts

f5_key   lda $0314
         cmp #LO(callno)
         bne f5_end
         sei
         tya
         pha
         jsr setspd
         sta $d012
         lda #LO(call_1)
         sta $0314
         lda #HI(call_1)
         sta $0315
         lda f_type
         ora volume
         sta $d418
         pla
         tay
f5_end   lda #$00
         cli
         rts

f7_key   lda $0314
         cmp #LO(callno)
         beq f5_end
         sei
         txa
         pha
         tya
         pha
f7_fwd   ldx #$00
         dex
         bne *-1
         dex
         bne *-1
         jsr fast_f
         lda #$fe
         sta $dc00
         lda $dc01
         and #$08
         beq f7_fwd
         bit $d011
         bpl *-3
         bit $d011
         bmi *-3
         lda #$01
         sta $d019
         pla
         tay
         pla
         tax
         lda #$00
         cli
         rts

fast_f   dec e_clkt        ;time
         bne fast_e
         lda #$32          ;50 frames
         sta e_clkt
         lda #$19
         sta irqpnt+1
         lda #$07
         sta irqpnt+2
         lda e_secs
         sed
         clc
         adc #$01          ;inc secs
         cmp #$60
         beq fast_m
         sta e_secs
         cld
         jmp fast_s
fast_m   lda #$00          ;1 min
         sta e_secs
         lda e_mins
         clc
         adc #$01          ;inc mins
         cmp #$60
         bne fast_n
         lda #$00          ;1 hour
fast_n   sta e_mins
         cld
         ldx #$00
         jsr irqout
         lda e_secs
fast_s   ldx #$03
         jsr irqout
fast_e   jmp $4003

f6_key   dec e_tune
         jmp *+6
f8_key   inc e_tune
         txa
         pha
         lda zp9
         pha
         lda e_tune
         and #$1f
         sta e_tune
         tax
         jsr startw
         lda start1,x
         sta e_tr1p
         sta zp9
         jsr tr1out
         lda start2,x
         sta e_tr2p
         sta zp9
         jsr tr2out
         lda start3,x
         sta e_tr3p
         sta zp9
         jsr tr3out
         pla
         sta zp9
         pla
         tax
         lda #$01
         rts

onoff1   lda e_tr1x        ;trk1 on
         eor #$62          ;toggle
         sta e_tr1x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr1x
         sta $0430
         lda #$00
         rts
onoff2   lda e_tr2x
         eor #$62
         sta e_tr2x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr2x
         sta $0439
         lda #$00
         rts
onoff3   lda e_tr3x
         eor #$62
         sta e_tr3x
         lda $0429
         cmp #$54
         bne *+8
         lda e_tr3x
         sta $0442
         lda #$00
         rts

sounds   jsr sndtab        ;screen
         ldy e_sndn
         lda snd_wt,y
         sta zp9
         jsr wvetab
         lda snd_ft,y
         sta zp9
         jsr flttab
         lda snd_pt,y
         sta zp9
         jsr plstab
         lda e_gldp
         sta zp9
         jsr gldtab
         lda snd_st,y
         sta zp9
         jsr sldtab
         lda e_tune
         sta zp9
         jmp trstab

startw   txa               ;corner
         pha
         lda #$9e
         sta numpnt+1
         lda #$06
         sta numpnt+2
         ldx e_tune
         lda start1,x      ;trst
         ldx #$00
         jsr numout
         ldx e_tune
         lda start2,x
         ldx #$03
         jsr numout
         ldx e_tune
         lda start3,x
         ldx #$06
         jsr numout
         lda e_rmax
         ldx #$56
         jsr numout
         lda e_mins        ;time
         ldx #$7b
         jsr numout
         lda e_secs
         ldx #$7e
         jsr numout
         lda e_tune        ;tune#
         ldx #$cb
         jsr numout
         ldx e_tune
         lda speeds,x
         ldx #$ce
         jsr numout
         pla
         tax
         rts

keychk   cmp #$2c          ;trk.sw.
         bne *+5
         jmp onoff1
         cmp #$2e
         bne *+5
         jmp onoff2
         cmp #$2f
         bne *+5
         jmp onoff3
         cmp #$85          ;f-keys
         bne *+5
         jmp f1_key
         cmp #$86
         bne *+5
         jmp f3_key
         cmp #$87
         bne *+5
         jmp f5_key
         cmp #$88
         bne *+5
         jmp f7_key
         cmp #$89
         bne *+5
         jmp f2_key
         cmp #$8a
         bne *+5
         jmp f4_key
         cmp #$8b
         bne *+12
         lda $0429
         cmp #$53
         beq keyfnd
         jmp f6_key
         cmp #$8c
         bne *+14
         lda $0429
         cmp #$53
         beq keyfnd
         jmp f8_key
keyfnd   lda #$00
         rts

         *= $1898
w_edit   = *
         *= $1afa
f_edit   = *
         *= $1d6c
p_edit   = *
         *= $1fde
g_edit   = *
         *= $2193
v_edit   = *
         *= $2405
r_edit   = *
         *= $2609
i_edit   = *
         *= $27fb
t1edit   = *
         *= $2a56
t2edit   = *
         *= $2cc2
t3edit   = *
         *= $2f5c
s_edit   = *
         *= $320d
q_edit   = *
         *= $335e

m_nent   ldx #$18
         lda #$20
         sta filnam,x
         sta $07a5,x
         dex
         bpl *-7
         ldx #$00
         lda #$7f
         sta $07a5,x
n_newc   jsr getkey
         cmp #$0d
         bne *+8
         lda #$20
         sta $07a5,x
         rts
         cmp #$14
         bne n_keys
         cpx #$00
         beq n_newc
         lda #$20
         sta $07a5,x
         dex
         sta filnam,x
         jmp n_newc-5
n_keys   cpx #$18
         beq n_newc
         cmp #$20
         bcc n_newc
         cmp #$40
         beq n_newc
         cmp #$5b
         bcs n_newc
         sta filnam,x
         sta $07a5,x
         inx
         jmp n_newc-5

m_load   jsr m_nent
         cpx #$00
         bne *+3
         rts
         lda #$01
         ldx #$08
         ldy #$00
         jsr $ffba
         lda #$10
         ldx #LO(filnam)
         ldy #HI(filnam)
         jsr $ffbd
         jsr $ffc0
         bcc *+5
         jmp derror
         ldx #$01
         jsr $ffc6
         ldy #$00
         jsr basinp
         cmp #$00
         bne m_unid
         jsr basinp
         cmp #$40
         beq m_ltun        ;load tune
         cmp #$70
         beq m_ldat        ;load data
m_unid   ldx #$18
         lda msg_pl,x
         sta $07a5,x
         dex
         bpl *-7
         jsr $ffcc
         lda #$01
         jmp $ffc3

m_ltun   jsr $ffcc
         lda #$01
         jsr $ffc3
         ldx #$18
         lda msg_ld,x
         sta $07a5,x
         dex
         bpl *-7
         lda #$00
         ldx #$00
         ldy #$40
         jsr $ffd5
         jmp derror

m_ldat   ldx #$00
         jsr basinp
         cmp $4019,x       ;V01.20
         bne m_unid
         inx
         cpx #$05
         bne m_ldat+2
         jsr basinp
         ldx #$18          ;loading..
         lda msg_ld,x
         sta $07a5,x
         dex
         bpl *-7
         ldx #$00
m_lp01   jsr basinp        ;spd+trst
         sta $4700,x
         inx
         cpx #$80
         bne m_lp01
         ldx #$00
m_lp02   jsr basinp        ;gldtab
         sta $4840,x
         inx
         cpx #$20
         bne m_lp02
         ldx #$00
m_lp03   jsr basinp        ;sounds
         sta $4940,x
         inx
         bne m_lp03
m_lp04   jsr basinp
         sta $4a40,x
         inx
         cpx #$c0
         bne m_lp04
         jsr basinp        ;wavetab
         sta e_orad        ;length
         ldx #$00
m_lp05   jsr basinp
         sta $4b00,x
         jsr basinp
         sta $4c00,x
         inx
         cpx e_orad
         bne m_lp05
         cpx #$00
         beq *+13
         lda #$00
         sta $4b00,x
         sta $4c00,x
         inx
         bne *-7
         jsr basinp        ;flttab
         sta e_orad        ;length
m_lp06   jsr basinp
         sta $4d00,x
         jsr basinp
         sta $4e00,x
         jsr basinp
         sta $4f00,x
         inx
         cpx e_orad
         bne m_lp06
         cpx #$00
         beq *+16
         lda #$00
         sta $4d00,x
         sta $4e00,x
         sta $4f00,x
         inx
         bne *-10
         jsr basinp        ;plstab
         sta e_orad        ;length
m_lp07   jsr basinp
         sta $5000,x
         jsr basinp
         sta $5100,x
         jsr basinp
         sta $5200,x
         inx
         cpx e_orad
         bne m_lp07
         cpx #$00
         beq *+16
         lda #$00
         sta $5000,x
         sta $5100,x
         sta $5200,x
         inx
         bne *-10
         jsr basinp        ;sldtab
         sta e_orad        ;length
m_lp08   jsr basinp
         sta $5300,x
         jsr basinp
         sta $5400,x
         jsr basinp
         sta $5500,x
         inx
         cpx e_orad
         bne m_lp08
         cpx #$00
         beq *+16
         lda #$00
         sta $5300,x
         sta $5400,x
         sta $5500,x
         inx
         bne *-10
         lda #$58          ;tracks
         sta m_ptr1+2
         sta m_ptr2+2
m_lp09   jsr basinp
         sta e_orad        ;length
m_lp0a   jsr basinp
m_ptr1   sta $5800,x
         inx
         cpx e_orad
         bne m_lp0a
         cpx #$00
         beq *+16
         lda #$80
m_ptr2   sta $5800,x
         inx
         bne *-10
         inc m_ptr1+2
         inc m_ptr2+2
         lda m_ptr2+2
         cmp #$70
         bne m_lp09
         sta m_ptr3+2      ;sectors
         sta m_ptr4+2
m_lp0b   jsr $ffcf
         bit $90
         bvs m_fend
         ldy $90
         bne m_fend+8
         sta e_orad        ;length
m_lp0c   jsr $ffcf
         sta $d020
         sty $d020
m_ptr3   sta $7000,x
         bit $90
         bvs m_fend
         ldy $90
         bne m_fend+8
         inx
         cpx e_orad
         bne m_lp0c
         cpx #$00
         beq *+16
         lda #$5f
m_ptr4   sta $7000,x
         inx
         bne *-10
         inc m_ptr3+2
         inc m_ptr4+2
         lda m_ptr4+2
         cmp #$cf
         bne m_lp0b
m_fend   jsr $ffcc
         lda #$01
         jsr $ffc3
         jmp derror

m_svsw   jsr m_nent        ;save tune
         cpx #$00
         bne *+3
         rts
         ldx #$00
         ldy #$40          ;from
         stx $fd
         sty $fe
         ldx #$18
         lda msg_sv,x
         sta $07a5,x
         dex
         bpl *-7
         lda #$01
         ldx #$08
         ldy #$00
         jsr $ffba
         lda #$10
         ldx #LO(filnam)
         ldy #HI(filnam)
         jsr $ffbd
         lda #$ce
         sta m_ends+2
         ldx #$00
m_ends   lda $ce00,x
         cmp #$5f
         bne m_endf
         dex
         bne m_ends
         dec m_ends+2
         jmp m_ends
m_endf   lda #$fd
         ldx #$00
         ldy m_ends+2
         iny
         jsr $ffd8
         jmp derror

m_svdt   jsr m_nent
         cpx #$00
         bne *+3
         rts
         lda #$01
         ldx #$08
         ldy #$01
         jsr $ffba
         lda #$10
         ldx #LO(filnam)
         ldy #HI(filnam)
         jsr $ffbd
         jsr $ffc0
         bcc *+5
         jmp derror
         ldx #$18
         lda msg_sv,x      ;saving..
         sta $07a5,x
         dex
         bpl *-7
         ldx #$01
         jsr $ffc9
         lda #$00
         tay
         jsr basout
         lda #$70
         jsr basout
         ldx #$00
         lda $4019,x       ;V01.20
         jsr basout
         inx
         cpx #$06
         bne *-9
         ldx #$00
m_lp0d   lda $4700,x       ;spd+trst
         jsr basout
         inx
         cpx #$80
         bne m_lp0d
         ldx #$00
m_lp0e   lda $4840,x       ;gldtab
         jsr basout
         inx
         cpx #$20
         bne m_lp0e
         ldx #$00
m_lp0f   lda $4940,x       ;sounds
         jsr basout
         inx
         bne m_lp0f
m_lp10   lda $4a40,x
         jsr basout
         inx
         cpx #$c0
         bne m_lp10
         ldx #$00          ;wavetab
         dex
         beq *+7
         lda $4b00,x
         beq *-6
         inx               ;length
         txa
         sta e_orad
         jsr basout
         ldx #$00
m_lp11   lda $4b00,x
         jsr basout
         lda $4c00,x
         jsr basout
         inx
         cpx e_orad
         bne m_lp11
         ldx #$00          ;flttab
         dex
         beq *+7
         lda $4d00,x
         beq *-6
         inx               ;length
         txa
         sta e_orad
         jsr basout
         ldx #$00
m_lp12   lda $4d00,x
         jsr basout
         lda $4e00,x
         jsr basout
         lda $4f00,x
         jsr basout
         inx
         cpx e_orad
         bne m_lp12
         ldx #$00          ;plstab
         dex
         beq *+7
         lda $5000,x
         beq *-6
         inx               ;length
         txa
         sta e_orad
         jsr basout
         ldx #$00
m_lp13   lda $5000,x
         jsr basout
         lda $5100,x
         jsr basout
         lda $5200,x
         jsr basout
         inx
         cpx e_orad
         bne m_lp13
         ldx #$00          ;sldtab
         dex
         beq *+7
         lda $5300,x
         beq *-6
         inx               ;length
         txa
         sta e_orad
         jsr basout
         ldx #$00
m_lp14   lda $5300,x
         jsr basout
         lda $5400,x
         jsr basout
         lda $5500,x
         jsr basout
         inx
         cpx e_orad
         bne m_lp14
         lda #$58          ;tracks
         sta m_ptr5+2
         sta m_ptr6+2
m_lp15   ldx #$00
         dex
         beq *+9
m_ptr5   lda $5800,x
         cmp #$ff
         bne *-8
         inx
         inx
         txa
         sta e_orad        ;length
         jsr basout
         ldx #$00
m_ptr6   lda $5800,x
         jsr basout
         inx
         cpx e_orad
         bne m_ptr6
         inc m_ptr5+2
         inc m_ptr6+2
         lda m_ptr6+2
         cmp #$70
         bne m_lp15
         sta m_ptr7+2      ;sectors
         sta m_ptr8+2
         ldx #$ff
m_ptr7   lda $7000,x
         cmp #$5f
         bne m_lp16
         dex
         cpx #$ff
         bne m_ptr7
         jmp m_fend
m_lp16   inx
         txa
         sta e_orad        ;length
         jsr basout
         ldx #$00
m_ptr8   lda $7000,x
         jsr basout
         inx
         cpx e_orad
         bne m_ptr8
         inc m_ptr7+2
         inc m_ptr8+2
         lda m_ptr8+2
         cmp #$cf
         bne m_ptr7-2
         jmp m_fend

basout   jsr $ffd2
         jmp *+6
basinp   jsr $ffcf
         sta $d020
         sty $d020
         ldy $90
         bne *+3
         rts
         pla
         pla
derror   lda $90
         pha
         jsr $ffcc
         lda #$01
         jsr $ffc3
         pla
         bpl rdrive
         ldx #$18
         lda msg_np,x
         sta $07a5,x
         dex
         bpl *-7
         rts
rdrive   ldx #$18
         lda #$20
         sta $07a5,x
         dex
         bpl *-4
         lda #$01
         ldx #$08
         ldy #$0f
         jsr $ffba
         lda #$00
         tax
         tay
         jsr $ffbd
         jsr $ffc0
         ldx #$01
         jsr $ffc6
         ldx #$00
         jsr $ffcf
         sta $07a5,x       ;00,
         inx
         cpx #$03
         bne *-9
         jsr $ffcf
         cmp #$20          ;1st spc
         bne *+5
rdloop   jsr $ffcf
         cmp #$2c
         beq rdcomm
         sta $07a5,x
         inx
         cpx #$13
         bne rdloop
         jsr $ffcf
         cmp #$2c
         beq rdcomm
         lda #$2a
         sta $07b7         ;*
         bne *-12
rdcomm   sta $07a5,x
         inx
         ldy #$05
         jsr $ffcf
         sta $07a5,x
         inx
         dey
         bne *-8
         jsr $ffcf
         jsr $ffcc
         lda #$01
         jmp $ffc3

m_dirr   lda #$01
         ldx #$08
         ldy #$00
         jsr $ffba
         lda e_orad
         ldx #LO(filnam)
         ldy #HI(filnam)
         jsr $ffbd
         jsr $ffc0         ;open
         bcc *+5
         jmp derror
         lda #$37
         sta $01
         jsr $e544
         lda #$15
         sta $d018
         lda #$00
         sta $d021
         ldx #$01
         jsr $ffc6         ;chkin
         jsr $ffcf         ;load addr
         jsr $ffcf
m_newl   lda #$06
         sta $d3
         jsr $ffcf
         ldx $90
         bmi m_endd
         bne m_derr
         jsr $ffcf
         beq m_endd
         jsr $ffcf         ;blocks
         ldx $90
         bmi m_endd
         bne m_derr
         tax
         jsr $ffcf
         jsr $bdcd         ;out
         lda #$20
         jsr $ffd2
m_line   jsr $ffcf
         beq m_lend
         ldx $90
         bmi m_endd
         bne m_derr
         jsr $ffd2
         jmp m_line
m_lend   lda #$0d
         jsr $ffd2
         lda $028d
         and #$04
         bne *-5
         lda $cb
         cmp #$3f
         bne m_newl
         jmp m_endd

m_derr   jsr $ffcc
         lda #$01
         jsr $ffc3
         lda #$01
         ldx #$08
         ldy #$0f
         jsr $ffba
         lda #$00
         tax
         tay
         jsr $ffbd
         jsr $ffc0
         ldx #$01
         jsr $ffc6
         lda #$0d
         jsr $ffd2
         jsr $ffd2
         lda #$06
         sta $d3
         jsr $ffcf
         jsr $ffd2
         cmp #$0d
         bne *-8

m_endd   jsr $ffcc         ;clrch
         lda #$01
         jsr $ffc3         ;close
         jsr getkey
         lda #$0b
         sta $d021
         jsr $e544

scn_ed   sei
         lda #$35
         sta $01
         lda #$13
         sta $d018
         ldx #$00
loop05   lda $e000,x
         sta $0400,x
         lda $e100,x
         sta $0500,x
         lda $e200,x
         sta $0600,x
         lda $e300,x
         sta $0700,x
         inx
         bne loop05
         lda e_tr1x
         sta $0430
         lda e_tr2x
         sta $0439
         lda e_tr3x
         sta $0442
         lda e_tr1p
         sta zp9
         jsr tr1out
         lda e_tr2p
         sta zp9
         jsr tr2out
         lda e_tr3p
         sta zp9
         jsr tr3out
         lda #$00
         sta zp9
         jsr sctout
         jsr sctlen
         lda e_gldp
         sta zp9
         jsr gldtab
         jsr startw
         lda #$01
         sta $d019
         lda #$36
         sta $01
         cli
         rts

scn_sd   sei
         lda #$35
         sta $01
         ldx #$00
loop06   lda $e400,x
         sta $0400,x
         lda $e500,x
         sta $0500,x
         lda $e600,x
         sta $0600,x
         lda $e700,x
         sta $0700,x
         inx
         bne loop06
         lda #$01
         sta $d019
         lda #$36
         sta $01
         cli
         rts

m_dcom   jsr m_nent
         cpx #$00
         bne *+3
         rts
         lda filnam
         cmp #$24
         bne m_dcmd
         stx e_orad
         jmp m_dirr
m_dcmd   txa
         pha
         lda #$01
         ldx #$08
         ldy #$0f
         jsr $ffba
         pla
         ldx #LO(filnam)
         ldy #HI(filnam)
         jsr $ffbd
         jsr $ffc0
         jmp derror

d_edit   ldy #$00
         ldx e_tune
         lda start1,x
         sta e_tr1p
         sta zp9
         jsr tr1out
         lda start2,x
         sta e_tr2p
         sta zp9
         jsr tr2out
         lda start3,x
         sta e_tr3p
         sta zp9
         jsr tr3out
         lda #$00
         sta zp9
         jsr sctout
         jsr sctlen
         lda e_gldp
         sta zp9
         jsr gldtab
         jsr startw
d_loop   jsr colgld
         ldx x_line,y
         lda #$01
         sta $dadd,x
         sta $dade,x
         sta $dadf,x
         sta $dae0,x
         sta $dae1,x
         sta $dae2,x
         sta $dae3,x
         sta $dae4,x
         sta $dae5,x
d_newc   jsr getkey
         cmp #$0d
         bne d_down
         jsr f3_key
         tya
         pha
         bne *+8
         jsr m_load
         jmp d_jend
         cpy #$01
         bne *+8
         jsr m_svdt
         jmp d_jend
         cpy #$02
         bne *+8
         jsr m_svsw
         jmp d_jend
         jsr m_dcom
d_jend   pla
         tay
         jmp d_edit+2
d_down   cmp #$11
         bne d_home
         cpy #$03
         beq d_newc
         iny
         jmp d_loop
d_home   cmp #$13
         bne d_uppp
         ldy #$00
         jmp d_loop
d_uppp   cmp #$91
         bne d_gsnd
         tya
         beq d_newc
         dey
         jmp d_loop
d_gsnd   cmp #$21          ;exit
         bcc d_newc
         cmp #$28
         bcs d_scrn
         and #$07
         tay
         jmp colgld
d_scrn   cmp #$5f          ;to editor
         bne d_tr1x
         ldy #$00
         jmp colgld
d_tr1x   jsr keychk
         bne *+5
         jmp d_newc
         jmp d_edit+2

m_entp   jsr $ff5b
         sei
         ldx #$ff
         txs
         cld
         lda #$ad
         sta $0314
         lda #$0c
         sta $0315
         lda #$c1
         sta $0318
         lda #$7f
         sta $dc0d
         lda #$01
         sta $d01a
         sta $0289
         lda #$80
         sta $028a
         sta $0291
         lda #$1b
         sta $d011
         lda #$fa
         sta $d012
         lda #$00
         sta $d020
         jsr $ff90
         lda #$0b
         sta $d021
         lda #$0f
         sta $0286
         jsr $e544

         jsr scn_ed
         jsr t1edit
looped   cpy #$00
         beq loopsd-6
         cpy #$01
         bne *+5
         jsr t1edit
         cpy #$02
         bne *+5
         jsr t2edit
         cpy #$03
         bne *+5
         jsr t3edit
         cpy #$04
         bne *+5
         jsr s_edit
         cpy #$05
         bne *+5
         jsr g_edit
         cpy #$06
         bne *+5
         jsr d_edit
         cpy #$07
         bne looped
         jsr q_edit
         jmp looped

         jsr scn_sd
         jsr i_edit
loopsd   cpy #$00
         beq looped-6
         cpy #$01
         bne *+5
         jsr i_edit
         cpy #$02
         bne *+14
         lda #$07
         ldx #$08
         ldy #$00
         jsr msgset
         jsr w_edit
         cpy #$03
         bne *+14
         lda #$09
         ldx #$0b
         ldy #$0c
         jsr msgset
         jsr f_edit
         cpy #$04
         bne *+14
         lda #$09
         ldx #$0e
         ldy #$0d
         jsr msgset
         jsr p_edit
         cpy #$05
         bne *+14
         lda #$0b
         ldx #$0a
         ldy #$00
         jsr msgset
         jsr g_edit
         cpy #$06
         bne *+14
         lda #$09
         ldx #$0b
         ldy #$0a
         jsr msgset
         jsr v_edit
         cpy #$07
         bne loopsd
         lda #$0f
         ldx #$10
         ldy #$11
         jsr msgset
         jsr r_edit
         jmp loopsd

msgset   sta e_msg1
         stx e_msg2
         sty e_msg3
         rts


len_lo   .byte $00
len_hi   .byte $00
actdur   .byte $00
e_tune   .byte $00         ;tune#
e_acts   .byte $00         ;speed
e_sctn   .byte $00         ;sct.#
e_ltrk   .byte $01         ;last trk
e_octv   .byte $00         ;octave
e_tr1p   .byte $00         ;trk.pos
e_tr2p   .byte $00
e_tr3p   .byte $00
e_tr1x   .byte $7a         ;trk.on
e_tr2x   .byte $7a
e_tr3x   .byte $7a
e_msg1   .byte $00         ;message
e_msg2   .byte $00
e_msg3   .byte $00
e_gldp   .byte $00         ;gld.pos
e_sndn   .byte $00         ;snd.#
e_spos   .byte $00         ;sretpos
e_test   .byte $00         ;t.note
e_radd   .byte $00
e_ract   .byte $00
e_rmax   .byte $00
e_clkt   .byte $00         ;timing
e_secs   .byte $00         ;clock sec
e_mins   .byte $00         ;clock min
e_orad   .byte $00         ;ora-reg

call1s   .byte LO(call_1),LO(call_2),LO(call_2)
         .byte LO(call_2),LO(call_2),LO(call_2)
         .byte LO(call_2),LO(call_2),LO(call_2)
         .byte LO(call_2)
call2s   .byte $00,LO(call_1),LO(call_3)
         .byte LO(call_3),LO(call_3),LO(call_3)
         .byte LO(call_3),LO(call_3),LO(call_3)
         .byte LO(call_3)
call3s   .byte $00,$00,LO(call_1),LO(call_4)
         .byte LO(call_4),LO(call_4),LO(call_4)
         .byte LO(call_4),LO(call_4),LO(call_4)
call4s   .byte $00,$00,$00,LO(call_1)
         .byte LO(call_5),LO(call_5),LO(call_5)
         .byte LO(call_5),LO(call_5),LO(call_5)
call5s   .byte $00,$00,$00,$00,LO(call_1)
         .byte LO(call_6),LO(call_6),LO(call_6)
         .byte LO(call_6),LO(call_6)
call6s   .byte $00,$00,$00,$00,$00
         .byte LO(call_1),LO(call_7),LO(call_7)
         .byte LO(call_7),LO(call_7)
call7s   .byte $00,$00,$00,$00,$00,$00
         .byte LO(call_1),LO(call_8),LO(call_8)
         .byte LO(call_8)
call8s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,LO(call_1),LO(call_9)
         .byte LO(call_9)
call9s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,LO(call_1),LO(call_0)
call0s   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,LO(call_1)

call1r   .byte $46,$d8,$8e,$66,$4f,$4a
         .byte $3c,$3a,$36,$2e
call2r   .byte $00,$42,$f0,$b0,$88,$76
         .byte $62,$5a,$52,$48
call3r   .byte $00,$00,$2c,$fa,$c1,$a2
         .byte $88,$7a,$6e,$62
call4r   .byte $00,$00,$00,$1c,$fa,$ce
         .byte $ae,$9a,$8a,$7c
call5r   .byte $00,$00,$00,$00,$0e,$fa
         .byte $d4,$ba,$a6,$96
call6r   .byte $00,$00,$00,$00,$00,$0a
         .byte $fa,$da,$c2,$b0
call7r   .byte $00,$00,$00,$00,$00,$00
         .byte $16,$fa,$de,$ca
call8r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$14,$fa,$e4
call9r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$10,$fe
call0r   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$08

call1j   .byte $31,$81,$81,$81,$81,$81
         .byte $81,$81,$81,$81
call2j   .byte $00,$31,$81,$81,$81,$81
         .byte $81,$81,$81,$81
call3j   .byte $00,$00,$31,$81,$81,$81
         .byte $81,$81,$81,$81
call4j   .byte $00,$00,$00,$31,$81,$81
         .byte $81,$81,$81,$81
call5j   .byte $00,$00,$00,$00,$31,$81
         .byte $81,$81,$81,$81
call6j   .byte $00,$00,$00,$00,$00,$31
         .byte $81,$81,$81,$81
call7j   .byte $00,$00,$00,$00,$00,$00
         .byte $31,$81,$81,$81
call8j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$31,$81,$81
call9j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$31,$81
call0j   .byte $00,$00,$00,$00,$00,$00
         .byte $00,$00,$00,$31

fncadl   .byte LO(fnctxt)+$00,LO(fnctxt)+$12
         .byte LO(fnctxt)+$24,LO(fnctxt)+$36
         .byte LO(fnctxt)+$48,LO(fnctxt)+$5a
         .byte LO(fnctxt)+$6c,LO(fnctxt)+$7e
         .byte LO(fnctxt)+$90,LO(fnctxt)+$a2
         .byte LO(fnctxt)+$b4,LO(fnctxt)+$c6
         .byte LO(fnctxt)+$d8,LO(fnctxt)+$ea
         .byte LO(fnctxt)+$fc,LO(fnctxt)+$0e
         .byte LO(fnctxt)+$20,LO(fnctxt)+$32

fncadh   .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$00
         .byte HI(fnctxt)+$00,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01
         .byte HI(fnctxt)+$01,HI(fnctxt)+$01

rstart   .byte $46,$42,$2c,$1c,$0e,$0a
         .byte $16,$14,$10,$08
etrack   .byte $00,$80,$ff,$01
ttrack   .byte $00,$df,$ff,$01
x_line   .byte $00,$28,$50,$78
         .byte $a0,$c8,$00,$00
octave   .byte $00,$0c,$18,$24
         .byte $30,$3c,$48,$54
twelve   .text "c-c#d-d#e-f-"
         .text "f#g-g#a-a#b-"
sc_snd   .text "snd.  "
sc_dur   .text "dur.  "
sc_gld   .text "gld.  "
sc_end   .text "-end!-"
sc_hld   .text "-hold-"
sc_rst   .text "------"
tr_tup   .byte $54,$12,$2b,$20,$20  ;"Tr+  "
tr_tdn   .byte $54,$12,$2d,$20,$20  ;"Tr-  "
tr_sct   .byte $53,$03,$14,$20,$20  ;"Sct  "
tr_vol   .byte $56,$0f,$0c,$20,$20  ;"Vol  "
tr_hlt   .byte $48,$0c,$14,$56,$50  ;"HltVP"
tr_dec   .byte $44,$05,$03,$20,$20  ;"Dec  "
tr_inc   .byte $49,$0e,$03,$20,$20  ;"Inc  "
tr_jmp   .byte $4a,$0d,$10,$20,$20  ;"Jmp  "

fnctxt   .byte $41,$14,$14,$01,$03,$0b  ;"Attack + Decay    "
         .byte $20,$2b,$20,$44,$05,$03
         .byte $01,$19,$20,$20,$20,$20
         .byte $53,$15,$13,$14,$01,$09  ;"Sustain + Release "
         .byte $0e,$20,$2b,$20,$52,$05
         .byte $0c,$05,$01,$13,$05,$20
         .byte $47,$01,$14,$05,$20,$0f  ;"Gate off counter  "
         .byte $06,$06,$20,$03,$0f,$15
         .byte $0e,$14,$05,$12,$20,$20
         .byte $41,$12,$10,$05,$07,$07  ;"Arpeggio pointer  "
         .byte $09,$0f,$20,$10,$0f,$09
         .byte $0e,$14,$05,$12,$20,$20
         .byte $46,$09,$0c,$14,$05,$12  ;"Filter pointer    "
         .byte $20,$10,$0f,$09,$0e,$14
         .byte $05,$12,$20,$20,$20,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse pointer     "
         .byte $10,$0f,$09,$0e,$14,$05
         .byte $12,$20,$20,$20,$20,$20
         .byte $53,$0c,$09,$04,$05,$20  ;"Slide pointer     "
         .byte $10,$0f,$09,$0e,$14,$05
         .byte $12,$20,$20,$20,$20,$20
         .byte $57,$01,$16,$05,$06,$0f  ;"Waveform / Command"
         .byte $12,$0d,$20,$2f,$20,$43
         .byte $0f,$0d,$0d,$01,$0e,$04
         .byte $41,$12,$10,$05,$07,$07  ;"Arpeggio steps    "
         .byte $09,$0f,$20,$13,$14,$05
         .byte $10,$13,$20,$20,$20,$20
         .byte $52,$05,$10,$05,$01,$14  ;"Repeat / Command  "
         .byte $20,$2f,$20,$43,$0f,$0d
         .byte $0d,$01,$0e,$04,$20,$20
         .byte $46,$12,$05,$11,$15,$05  ;"Frequency low     "
         .byte $0e,$03,$19,$20,$0c,$0f
         .byte $17,$20,$20,$20,$20,$20
         .byte $46,$12,$05,$11,$15,$05  ;"Frequency high    "
         .byte $0e,$03,$19,$20,$08,$09
         .byte $07,$08,$20,$20,$20,$20
         .byte $52,$05,$13,$0f,$0e,$01  ;"Resonance + F.low "
         .byte $0e,$03,$05,$20,$2b,$20
         .byte $46,$2e,$0c,$0f,$17,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse width low   "
         .byte $17,$09,$04,$14,$08,$20
         .byte $0c,$0f,$17,$20,$20,$20
         .byte $50,$15,$0c,$13,$05,$20  ;"Pulse width high  "
         .byte $17,$09,$04,$14,$08,$20
         .byte $08,$09,$07,$08,$20,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 1 startpos. "
         .byte $31,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 2 startpos. "
         .byte $32,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20
         .byte $54,$12,$01,$03,$0b,$20  ;"Track 3 startpos. "
         .byte $33,$20,$13,$14,$01,$12
         .byte $14,$10,$0f,$13,$2e,$20

filnam   .text "            "
         .text "             "
msg_ld   .byte $50,$0c,$05,$01,$13,$05  ;"Please wait,"
         .byte $20,$17,$01,$09,$14,$2c
         .byte $20,$0c,$0f,$01,$04,$09  ;" loading...  "
         .byte $0e,$07,$2e,$2e,$2e,$20
         .byte $20
msg_sv   .byte $50,$0c,$05,$01,$13,$05  ;"Please wait,"
         .byte $20,$17,$01,$09,$14,$2c
         .byte $20,$13,$01,$16,$09,$0e  ;" saving...   "
         .byte $07,$2e,$2e,$2e,$20,$20
         .byte $20
msg_np   .byte $44,$05,$16,$09,$03,$05  ;"Device 8 not"
         .byte $20,$38,$20,$0e,$0f,$14
         .byte $20,$10,$12,$05,$13,$05  ;" present     "
         .byte $0e,$14,$20,$20,$20,$20
         .byte $20
msg_pl   .byte $55,$0e,$09,$04,$05,$0e  ;"Unidentified"
         .byte $14,$09,$06,$09,$05,$04
         .byte $20,$10,$0c,$01,$19,$05  ;" player      "
         .byte $12,$20,$20,$20,$20,$20
         .byte $20

;---------------------------------------
.end
