colorRams:
    byt 0
	byt 0
	byt 0
	byt 0

colorBufferChange:
	byt 1

counter = $d0


	proc initIrq

	sei
	lda colorRams
	sta colorRam0
	lda colorRams+1
	sta colorRam1
	lda colorRams+2
	sta colorRam2
	lda colorRams+3
	sta colorRam3
	lda $ff06
	sta yscroll0 ;3
	eor #4
	sta yscroll2 ;7
	eor #2
	sta yscroll1 ;5
	eor #4
	sta yscroll3 ;1

	;timer beallitas

	lda #lo(timeingIrq)
	sta $fffe
	lda #hi(timeingIrq)
	sta $ffff
	lda #2		;raster irq
	sta $ff0a
	lda #5		;don't change
	sta $ff0b
	lda $ff09
	sta $ff09
	
	lda #0
	sta counter
	
	cli

w:	lda counter	; wait
	beq w

	sei

	lda #lo(rasterIrq)
	sta $fffe
	lda #hi(rasterIrq)
	sta $ffff
	lda #0
	sta $ff0b

	lda $ff09
	sta $ff09
	rts

	align 64
	
timeingIrq:
	sta tempa
	lda $ff1e	;stabilizaljuk a rasztert
	lsr
	lsr
	sta reljump
reljump = *+1
	bpl *+2		;vigyazni kell, hogy a kov. nop ugyanebben
	cmp #$c9	;a 256 byteos blokkban legyen, kulonben
	cmp #$c9	;elromlik az idozites!
	cmp #$c9
	cmp #$c9
	cmp #$c9
	cmp #$c5
	nop
	; stabil!

	;76*4+53 cycle = 357
	lda #0		;2
tl:	bit $ffff	;4
	clc			;2
	adc #01		;2
	cmp #27		;2
	bne tl		;3 v 2
	bit $ffff	;3
	
;	REPT 76
;	bit $ffff	;4
;	ENDM
	
;	bit $ffff	;53 cycle
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ffff
;	bit $ff
;	nop

	lda #lo(4*57)
	sta $ff00
	lda #hi(4*57)
	sta $ff01

	inc counter

	inc $ff09
	
tempa = *+1
	lda #0
	rti
	

rasterIrq:
	pha
	lda #lo(dfliIrq0)
	sta $fffe
	lda #hi(dfliIrq0)
	sta $ffff
	lda #8		;timer1 irq
	sta $ff0a
	lda #25
	sta counter

	;buffer change
	lda colorBufferChange
	beq nobch	;no change
	lda colorRams
	sta $ff14
	sta colorRam0
	lda colorRams+1
	sta colorRam1
	lda colorRams+2
	sta colorRam2
	lda colorRams+3
	sta colorRam3

	lda #0
	sta colorBufferChange
nobch:
	lda #2
	cmp $ff1d
	bne *-3

	inc $ff09

	ifdef	effectInIrq

inProgress = *+1
	lda #0
	bne running

	inc inProgress

	cli
	txa
	pha
	tya
	pha
	jsr effectInIrq
	pla
	tay
	pla
	tax

	dec inProgress

running:
	endif

	pla
	rti


	align 256
	
dfliIrq0:
	sta tempa0
colorRam1 = *+1
	lda #0
	sta $ff14
yscroll1 = *+1
	lda #0
	sta $ff06
	inc $ff09
	inc $ffff
yscroll2 = *+1
	lda #0
	sta $ff06
	lda #0
	sta $ff1b	;igy kell csak ket sornyi bitmap
colorRam2 = *+1
	lda #0
	sta $ff14
tempa0 = *+1
	lda #0
	rti

	align 256

dfliIrq1:
	sta tempa1
colorRam3 = *+1
	lda #0
	sta $ff14
yscroll3 = *+1
	lda #0
	sta $ff06
	inc $ff09
	dec $ffff
yscroll0 = *+1
	lda #0
	sta $ff06
colorRam0 = *+1
	lda #0
	sta $ff14

	dec counter
	bne out

	lda #lo(rasterIrq)
	sta $fffe
	lda #hi(rasterIrq)
	sta $ffff
	lda #2		;raster irq
	sta $ff0a

	ifdef	player
	stx tempx
	sty tempy
	jsr player
tempx= *+1
	ldx #0
tempy= *+1
	ldy #0
	endif

out:
tempa1 = *+1
	lda #0
	rti

	endproc	initIrq
