
code_start = $1001

.org code_start-2
	.word code_start; for the .prg file

;BASIC:	 2001 sys4109

	.word :+,2001
	.byte $9e	; sys token
	.byte "4109"
:	.byte 0,0,0


sys4109:
	jmp main


colorRam0 = $a000
colorRam01 = $a800
colorRam1 = $b000
colorRam11 = $b800
bitmap = $8000
effectInIrq = effect

.include "../src/zoom4irq_gr.s"
.include "../src/zoom4prep.s"


.proc	effect

	lda newColorRam0
	eor #((>colorRam0) ^ (>colorRam01))
	sta newColorRam0

	lda newColorRam1
	eor #((>colorRam1) ^ (>colorRam11))
	sta newColorRam1

rot = *+1
	ldx #0
	inx
	inx
	cpx #100
	bne :+
	ldx #0
:	stx rot
	jsr updateRenderSrc
	
	jsr updateRenderScreenHiAddr

	jsr render
	
	inc colorBufferChange
	rts

.endproc


.proc	main

	sei
	sta $ff3f

	jsr initBitmap
	jsr setGrMode

	ldx #>colorRam0
	ldy #>colorRam1
	jsr initIrq

	jsr effect	;1st frame

	lda #0
	sta $ff19

	cli

c:	jmp c

.endproc


.proc	updateRenderSrc

	clc
.repeat 50,i
	txa
	adc sintab+i
	tay
	lda tab_lo,y
	sta render+12*i+3
	sta render+12*i+9
	lda tab_hi,y
	sta render+12*i+4
	adc #4
	sta render+12*i+10
.endrep
	rts
	
.endproc


.proc	updateRenderScreenHiAddr

	lda newColorRam0
	ldx #7
	jsr update
	adc #1
	ldx #13
	jsr update

	lda newColorRam1
	ldx #7+12
	jsr update
	adc #1
	ldx #13+12
	
update:	clc
	
	sta render+0*24,x
	sta render+1*24,x
	sta render+2*24,x
	sta render+3*24,x
	sta render+4*24,x
	sta render+5*24,x
	sta render+6*24,x

	adc #1
	sta render+7*24,x
	sta render+8*24,x
	sta render+9*24,x
	sta render+10*24,x
	sta render+11*24,x
	sta render+12*24,x

	adc #1
	sta render+13*24,x
	sta render+14*24,x
	sta render+15*24,x
	sta render+16*24,x
	sta render+17*24,x
	sta render+18*24,x
	sta render+19*24,x

	adc #1
	sta render+20*24,x
	sta render+21*24,x
	sta render+22*24,x
	sta render+23*24,x
	sta render+24*24,x
	rts
	
.endproc


.proc	render
	ldx #0
c:
.repeat 25,i
	lda $ffff,x
	sta colorRam0+i*40,x
	lda $ffff,x
	sta colorRam0+i*40+$800,x

	lda $ffff,x
	sta colorRam1+i*40,x
	lda $ffff,x
	sta colorRam1+i*40+$800,x
.endrep
	inx
	cpx #40
	beq out
	jmp c
out:	rts
.endproc


tab_lo:

.repeat 25,i
	.byte <(texture0+40*i)
	.byte <(texture1+40*i)
.endrep

.repeat 25,i
	.byte <(texture2+40*i)
	.byte <(texture3+40*i)
.endrep

.repeat 25,i
	.byte <(texture0+40*i)
	.byte <(texture1+40*i)
.endrep

.repeat 25,i
	.byte <(texture2+40*i)
	.byte <(texture3+40*i)
.endrep


tab_hi:
.repeat 25,i
	.byte >(texture0+40*i)
	.byte >(texture1+40*i)
.endrep
.repeat 25,i
	.byte >(texture2+40*i)
	.byte >(texture3+40*i)
.endrep

.repeat 25,i
	.byte >(texture0+40*i)
	.byte >(texture1+40*i)
.endrep
.repeat 25,i
	.byte >(texture2+40*i)
	.byte >(texture3+40*i)
.endrep


sintab:

.include "sintable.s"

texture0 = texture
texture1 = texture+1*$800
texture2 = texture+2*$800
texture3 = texture+3*$800

texture:
	.incbin "vole0.bin"
	.incbin "vole1.bin"
