colorBufferChange:
	.byte 1
newColorRam0:
	.byte 0	
newColorRam1:
	.byte 0

;XR:	$ff14 erteke a paros sorokhoz
;YR:	$ff14 erteke a paratlan sorokhoz
.proc	initIrq

	sei
	stx newColorRam0
	sty newColorRam1
	lda $ff06
	sta yscroll0
	eor #4
	sta yscroll1

	;timer beallitas

	lda #<timeingIrq
	sta $fffe
	lda #>timeingIrq
	sta $ffff
	lda #2		;raster irq
	sta $ff0a
	lda #5
	sta $ff0b
	lda $ff09
	sta $ff09
	cli

w:	lda counter	; wait
	beq w

	sei

	lda #<rasterIrq
	sta $fffe
	lda #>rasterIrq
	sta $ffff
	lda #2
	sta $ff0b

	lda $ff09
	sta $ff09
	rts

timeingIrq:
	sta tempa
	lda $ff1e	;stabilizaljuk a rasztert
	lsr
	lsr
	sta reljump
reljump = *+1
	bpl *+2		;vigyazni kell, hogy a kov. nop ugyanebben
	cmp #$c9	;a 256 byteos blokkban legyen, kulonben
	cmp #$c9	;elromlik az idozites!
	cmp #$c9
	cmp #$c9
	cmp #$c9
	cmp #$c5
	nop
	; stabil!

	bit $ffff	;53 cycle
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ffff
	bit $ff
	nop

	lda #<(8*57)
	sta $ff00
	lda #>(8*57)
	sta $ff01

	sta counter

	inc $ff09
	jmp irqe
	

rasterIrq:
	pha
	lda #<zoom4Irq
	sta $fffe
	lda #>zoom4Irq
	sta $ffff
	lda #8		;timer1 irq
	sta $ff0a
	lda #25
	sta counter
	inc $ff09

	;buffer change
	lda colorBufferChange
	beq nobch	;no change
	lda newColorRam0
	sta $ff14
	sta colorRam0
	lda newColorRam1
	sta colorRam1
	lda #0
	sta colorBufferChange
nobch:

.ifdef	effectInIrq

inProgress = *+1
	lda #0
	bne running

	inc inProgress

	cli
	txa
	pha
	tya
	pha
	jsr effectInIrq
	pla
	tay
	pla
	tax

	dec inProgress

running:
.endif

	pla
	rti

counter:
	.byte 0


zoom4Irq:
	sta tempa
colorRam1 = *+1
	lda #0
	sta $ff14
yscroll1 = *+1
	lda #0
	sta $ff06
	inc $ff09
yscroll0 = *+1
	lda #0
	sta $ff06
	lda #0
	sta $ff1b	;igy kell csak ket sornyi bitmap
	dec counter
	bne out

	lda #<rasterIrq
	sta $fffe
	lda #>rasterIrq
	sta $ffff
	lda #2		;raster irq
	sta $ff0a

.ifdef	player
	stx tempx
	sty tempy
	jsr player
tempx= *+1
	ldx #0
tempy= *+1
	ldy #0
.endif

out:
colorRam0 = *+1
	lda #0
	sta $ff14
irqe:
tempa = *+1
	lda #0
	rti

.endproc
